% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Goalie.R
\name{goalie_game_report}
\alias{goalie_game_report}
\title{Access various reports for a season, game type, and category for all
the goalies by game}
\usage{
goalie_game_report(
  season = season_now(),
  game_type = game_type_now(),
  category = "summary"
)
}
\arguments{
\item{season}{integer in YYYYYYYY (e.g., 20242025); see \code{\link[=seasons]{seasons()}} for
reference}

\item{game_type}{integer in 1:3 (where 1 = pre-season, 2 = regular season, 3
= playoff/post-season) OR character of 'pre', 'regular', or
playoff'/'post'; see \code{\link[=seasons]{seasons()}} for reference; most functions will NOT
support pre-season}

\item{category}{character (e.g., 'advanced'); see
\code{\link[=goalie_report_configurations]{goalie_report_configurations()}} for reference}
}
\value{
data.frame with one row per game per goalie
}
\description{
\code{goalie_game_report()} retrieves various reports for a season, game type, and category for all the goalies by game as a \code{data.frame} where each row represents game per goalie and includes detail on game timeline state, period/clock progression, and matchup flow, player identity, role, handedness, and biographical profile, and production, workload, efficiency, and result-level performance outcomes.
}
\examples{
# May take >5s, so skip.
\donttest{advanced_goalie_game_report_playoffs_20212022 <- 
  goalie_game_report(
    season    = 20212022, 
    game_type = 3, 
    category  = 'advanced'
  )}
}
