% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GoalieEDGE.R
\name{goalie_edge_leaders}
\alias{goalie_edge_leaders}
\title{Access the goalie EDGE statistics leaders for a season and game type}
\usage{
goalie_edge_leaders(season = "now", game_type = "")
}
\arguments{
\item{season}{integer in YYYYYYYY (e.g., 20242025); see
\code{\link[=goalie_edge_seasons]{goalie_edge_seasons()}} for reference}

\item{game_type}{integer in 1:3 (where 1 = pre-season, 2 = regular season, 3
= playoff/post-season) OR character of 'pre', 'regular', or
'playoff'/'post'; see \code{\link[=goalie_edge_seasons]{goalie_edge_seasons()}} for reference; most functions
will NOT support pre-season}
}
\value{
list of various items
}
\description{
\code{goalie_edge_leaders()} retrieves the goalie EDGE statistics leaders for a season and game type as a nested \code{list} that separates summary and detail blocks for NHL EDGE style tracking outputs and relative-performance context.
}
\examples{
goalie_EDGE_leaders_regular_20242025 <- goalie_edge_leaders(
  season    = 20242025,
  game_type = 2
)
}
