% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{GroupedComposition-class}
\alias{GroupedComposition-class}
\alias{.GroupedComposition}
\title{Grouped Compositional Matrix}
\description{
An S4 class to represent grouped compositional data.
}
\note{
This class inherits from \code{\linkS4class{CompositionMatrix}} and
\code{\linkS4class{ReferenceGroups}}.
}
\section{Coerce}{

In the code snippets below, \code{x} is a \code{GroupedComposition} object.
\describe{
\item{\code{as.data.frame(x)}}{Coerces to a \code{\link{data.frame}}.}
}
}

\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## codaccess
dim(coda) # Get the matrix dimensions
row(coda) # Get the row indexes
col(coda, as.factor = TRUE) # Get the column indexes
nrow(coda) # Get the number of rows
ncol(coda) # Get the number of columns
dimnames(coda) # Get the dimension names
rownames(coda) <- LETTERS[1:25] # Set the row names
rownames(coda) # Get the rownames
colnames(coda) <- letters[21:25] # Set the column names
colnames(coda) # Get the column names
}
\seealso{
\code{\link[=as_composition]{as_composition()}}

Other classes: 
\code{\link{CompositionMatrix-class}},
\code{\link{GroupedLogRatio-class}},
\code{\link{LogRatio-class}},
\code{\link{NumericMatrix-class}},
\code{\link{OutlierIndex-class}},
\code{\link{ReferenceGroups-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
