% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertex_partition.R
\name{generate_sigma_algebra}
\alias{generate_sigma_algebra}
\title{Sigma-Algebra generated by a Partition}
\usage{
generate_sigma_algebra(x)
}
\arguments{
\item{x}{Input partition stored as a \code{vertex_partition} object.}
}
\value{
Sigma-algebra
}
\description{
Sigma-Algebra generated by a Partition
}
\examples{
g <- igraph::make_ring(7)
m <- as.integer(c(1, 2, 1, 3, 4, 4, 3))
p <- as_vertex_partition(m)
sa <- generate_sigma_algebra(p)
all_full  <- purrr::modify_depth(sa, 2, ~ subgraph_full (g, .x))
all_intra <- purrr::modify_depth(sa, 2, ~ subgraph_intra(g, .x))
all_inter <- purrr::modify_depth(sa, 2, ~ subgraph_inter(g, .x))
}
