\name{japan_neutro}
\alias{japan_neutro}
\title{Japan Neutrosophic Interval Dataset}
\docType{data}
\description{
A dataset containing interval-valued measurements from Japan, suitable for neutrosophic statistical analysis.
The data includes both auxiliary and study variables with their minimum and maximum bounds.
}
\usage{
data(japan_neutro)
}
\format{
A data frame with 31 observations and 4 variables:
\describe{
  \item{Auxili_min}{Numeric vector representing the lower bounds of the auxiliary variable}
  \item{Auxili_max}{Numeric vector representing the upper bounds of the auxiliary variable}
  \item{Country}{Non-numeric vector representing country names}
  \item{Sex}{Non-numeric vector representing sex of particapant i.e. male or female}
  \item{Study_min}{Numeric vector representing the lower bounds of the study variable}
  \item{Study_max}{Numeric vector representing the upper bounds of the study variable}
  \item{Year}{Numeric vector representing year on which the data is collected}
}
}
\examples{
# Load the dataset
data(japan_neutro)

# View the first few rows
head(japan_neutro)

# Calculate basic metrics
metrics <- compute_all_metrics(japan_neutro)
print(metrics$mean_interval_X)  # Mean of auxiliary variable
print(metrics$mean_interval_Y)  # Mean of study variable
}
\keyword{datasets}
