% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neurovecseq.R
\name{NeuroVecSeq}
\alias{NeuroVecSeq}
\title{NeuroVecSeq: A Container for Sequential NeuroVec Objects}
\usage{
NeuroVecSeq(...)
}
\arguments{
\item{...}{One or more instances of type \code{\linkS4class{NeuroVec}}.}
}
\value{
A NeuroVecSeq object containing:
\itemize{
  \item The provided NeuroVec objects
  \item Associated space information
  \item Length information for each vector
}
}
\description{
The NeuroVecSeq class provides a container for managing a sequence of NeuroVec objects,
particularly useful for handling time series or multi-session neuroimaging data where
each segment may have different lengths.

Constructs a NeuroVecSeq object to represent a variable-length sequence of NeuroVec objects.
This is particularly useful for managing time series data where different segments may have
different lengths.
}
\details{
NeuroVecSeq objects store:
\itemize{
  \item A list of NeuroVec objects, each potentially with different time dimensions
  \item The lengths of each constituent NeuroVec
  \item A combined NeuroSpace object representing the total space
}

The class provides methods for:
\itemize{
  \item Accessing individual time points across all vectors
  \item Extracting subsequences
  \item Computing statistics across the sequence
  \item Linear access to the underlying data
}

The function performs several validations:
\itemize{
  \item Ensures all inputs are NeuroVec objects
  \item Verifies spatial compatibility
  \item Combines spatial information appropriately
}
}
\section{Methods}{

\describe{
  \item{[[}{Extract a single volume at a specified time point}
  \item{length}{Get the total number of time points}
  \item{sub_vector}{Extract a subsequence of volumes}
  \item{linear_access}{Access data linearly across all vectors}
}
}

\examples{
# Create some example NeuroVec objects
v1 <- NeuroVec(array(0, c(5, 5, 5, 2)),
               space = NeuroSpace(dim = c(5, 5, 5, 2)))
v2 <- NeuroVec(array(1, c(5, 5, 5, 4)),
               space = NeuroSpace(dim = c(5, 5, 5, 4)))
v3 <- NeuroVec(array(2, c(5, 5, 5, 6)),
               space = NeuroSpace(dim = c(5, 5, 5, 6)))

# Combine them into a sequence
vs <- NeuroVecSeq(v1, v2, v3)

# Access properties
length(vs)  # Total time points
vs[[5]]     # Get the 5th volume

# Extract a subsequence
sub_seq <- sub_vector(vs, 1:5)


# Create sample vectors
v1 <- NeuroVec(array(0, c(5, 5, 5, 2)),
               space = NeuroSpace(dim = c(5, 5, 5, 2)))
v2 <- NeuroVec(array(0, c(5, 5, 5, 4)),
               space = NeuroSpace(dim = c(5, 5, 5, 4)))

# Combine into sequence
vs <- NeuroVecSeq(v1, v2)
print(vs)


}
\seealso{
\code{\linkS4class{NeuroVec}} for the base vector class,
\code{\linkS4class{NeuroSpace}} for spatial information
}
