% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roi.R
\name{cuboid_roi}
\alias{cuboid_roi}
\title{Create A Cuboid Region of Interest}
\usage{
cuboid_roi(bvol, centroid, surround, fill = NULL, nonzero = FALSE)
}
\arguments{
\item{bvol}{an \code{NeuroVol} or \code{NeuroSpace} instance}

\item{centroid}{the center of the cube in \emph{voxel} coordinates}

\item{surround}{the number of voxels on either side of the central voxel. A \code{vector} of length 3.}

\item{fill}{optional value(s) to assign to data slot.}

\item{nonzero}{keep only nonzero elements from \code{bvol}. If \code{bvol} is A \code{NeuroSpace} then this argument is ignored.}
}
\value{
An instance of class \code{ROIVol} representing the cuboid region of interest, containing the coordinates and values of voxels within the specified region.
}
\description{
Create A Cuboid Region of Interest
}
\examples{
 sp1 <- NeuroSpace(c(10,10,10), c(1,1,1))
 cube <- cuboid_roi(sp1, c(5,5,5), 3)
 vox <- coords(cube)
 cube2 <- cuboid_roi(sp1, c(5,5,5), 3, fill=5)


}
