% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_info.R
\name{NIFTIMetaInfo}
\alias{NIFTIMetaInfo}
\title{Create NIFTI Format Metadata Object}
\usage{
NIFTIMetaInfo(descriptor, nifti_header)
}
\arguments{
\item{descriptor}{NIFTIFormat object specifying file format details}

\item{nifti_header}{List containing NIFTI header information}
}
\value{
A NIFTIMetaInfo object
}
\description{
Creates a NIFTIMetaInfo object containing format-specific metadata
  for NIFTI format neuroimaging files.
}
\details{
Create NIFTIMetaInfo Object


The NIFTIMetaInfo object extends MetaInfo with NIFTI-specific features:
\itemize{
  \item NIFTI header fields (qform, sform matrices)
  \item Data scaling (slope, intercept)
  \item File organization (separate vs. single file)
  \item Orientation information
}

Validation ensures:
\itemize{
  \item Valid NIFTI format
  \item Consistent dimensions
  \item Valid transformation matrices
  \item Proper data scaling
}
}
\examples{

# Read NIFTI header
header <- read_header(system.file("extdata", "global_mask_v4.nii", package="neuroim2"))

# Create format descriptor
fmt <- new("NIFTIFormat",
           file_format = "NIFTI",
           header_encoding = "raw",
           header_extension = "nii",
           data_encoding = "raw",
           data_extension = "nii")

# Create metadata
meta <- NIFTIMetaInfo(fmt, header@header)

# Check dimensions
dim(meta)


}
\seealso{
\code{\link{MetaInfo}}
}
