% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nemsqa_binomial_confint.R
\name{nemsqa_binomial_confint}
\alias{nemsqa_binomial_confint}
\title{Wilson and Clopper-Pearson Confidence Intervals for Binomial
Proportions}
\usage{
nemsqa_binomial_confint(
  data = NULL,
  x,
  n,
  method = c("wilson", "clopper-pearson"),
  conf.level = 0.95,
  correct = TRUE
)
}
\arguments{
\item{data}{An optional \code{tibble} or \code{data.frame} containing the variables \code{x}
and \code{n}. If provided, \code{x} and \code{n} should be column names.}

\item{x}{Numeric vector or column name (if \code{data} is provided) representing
the number of successes.}

\item{n}{Numeric vector or column name (if \code{data} is provided) representing
the total number of trials.}

\item{method}{Character string specifying the confidence interval method.
Must be either "wilson" (default) or "clopper-pearson".}

\item{conf.level}{Numeric value between 0 and 1 indicating the confidence
level. Defaults to 0.95 (95\% confidence interval).}

\item{correct}{Logical, indicating whether to apply continuity correction for
Wilson intervals. Defaults to \code{TRUE}.}
}
\value{
A \code{tibble} containing the estimated proportion (\code{prop}), lower confidence
interval (\code{lower_ci}), upper confidence interval (\code{upper_ci}), and a
formatted proportion label (\code{prop_label}). If \code{data} is provided, these
columns are appended to \code{data} via \code{dplyr::bind_cols()}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Computes confidence intervals for binomial proportions using either the
Wilson or Clopper-Pearson method. This function supports vectorized
operations and allows optional correction for continuity. The Wilson interval
is computed using \code{stats::prop.test()}, while the Clopper-Pearson interval is
computed using \code{stats::binom.test()}.
}
\details{
The Wilson confidence interval is calculated using \code{stats::prop.test()},
which provides an improved approximation to the binomial proportion
confidence interval by avoiding the instability of the Wald interval (Wilson,
1927). The Clopper-Pearson interval, computed using \code{stats::binom.test()}, is
an exact method based on the cumulative probabilities of the binomial
distribution (Clopper & Pearson, 1934).

The use of \code{match.arg()} within \code{nemsqar::nemsqa_binomial_confint()} allows
users to specify the method using partial matching, meaning they can enter
just "w" instead of "wilson" or "c" instead of "clopper-pearson".
}
\examples{
# Example without a data frame
nemsqa_binomial_confint(data = NULL,
                        x = c(5, 10, 20),
                        n = c(50, 100, 200),
                        method = "wilson"
                        )

# Example with a data.frame
data <- data.frame(successes = c(5, 10, 20), trials = c(50, 100, 200))
nemsqa_binomial_confint(data,
                        x = successes,
                        n = trials,
                        method = "clopper-pearson"
                        )

}
\references{
Clopper, C. J. & Pearson, E. S. (1934). The use of confidence or fiducial
limits illustrated in the case of the binomial. Biometrika, 26, 404–413.
\doi{10.2307/2331986}.

Wilson, E.B. (1927). Probable inference, the law of succession, and
statistical inference. Journal of the American Statistical Association, 22,
209–212. \doi{10.2307/2276774}.
}
