test_that("nstring conversions work", {
  s <- "hello WORLD"
  expect_equal(nstring(s, case = "lower"), "hello world")
  expect_equal(nstring(s, case = "upper"), "HELLO WORLD")
  expect_equal(nstring(s, case = "title"), "Hello World")
  expect_equal(nstring("hello world", case = "start"), "Hello World")
  expect_equal(nstring("HELLO WORLD", case = "initcap"), "Hello world")
})

test_that("nstring cleaning works", {
  expect_equal(
    nstring("  abcDEF are alphabets!!    "),
    "abcDEF are alphabets!!"
  )
  expect_equal(nstring("sp@cial!!", remove_specials = TRUE), "spcial")
  expect_equal(
    nstring("keep_underscore_",
      remove_specials = TRUE, keep_chars = "_"
    ),
    "keep_underscore_"
  )
})

test_that("strip_non_english works", {
  expect_equal(nstring("Café", ascii_only = TRUE), "Caf")
  expect_equal(nstring("Hello 123", ascii_only = TRUE), "Hello 123")
})
