% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_cpp_wrap.R
\name{sam.gen.ncpen}
\alias{sam.gen.ncpen}
\title{sam.gen.ncpen: generate a simulated dataset.}
\usage{
sam.gen.ncpen(n = 100, p = 50, q = 10, k = 3, r = 0.3,
  cf.min = 0.5, cf.max = 1, corr = 0.5, seed = NULL,
  family = c("gaussian", "binomial", "multinomial", "cox", "poisson"))
}
\arguments{
\item{n}{(numeric) the number of samples.}

\item{p}{(numeric) the number of variables.}

\item{q}{(numeric) the number of nonzero coefficients.}

\item{k}{(numeric) the number of classes for \code{multinomial}.}

\item{r}{(numeric) the ratio of censoring for \code{cox}.}

\item{cf.min}{(numeric) value of the minimum coefficient.}

\item{cf.max}{(numeric) value of the maximum coefficient.}

\item{corr}{(numeric) strength of correlations in the correlation structure.}

\item{seed}{(numeric) seed number for random generation. Default does not use seed.}

\item{family}{(character) model type.}
}
\value{
An object with list class containing
  \item{x.mat}{design matrix.}
  \item{y.vec}{responses.}
  \item{b.vec}{true coefficients.}
}
\description{
Generate a synthetic dataset based on the correlation structure from generalized linear models.
}
\details{
A design matrix for regression models is generated from the multivariate normal distribution with a correlation structure.
Then the response variables are computed with a specific model based on the true coefficients (see references).
Note the censoring indicator locates at the last column of \code{x.mat} for \code{cox}.
}
\examples{
### linear regression
sam =  sam.gen.ncpen(n=200,p=20,q=5,cf.min=0.5,cf.max=1,corr=0.5)
x.mat = sam$x.mat; y.vec = sam$y.vec
head(x.mat); head(y.vec)
}
\references{
Kwon, S., Lee, S. and Kim, Y. (2016). Moderately clipped LASSO.
\emph{Computational Statistics and Data Analysis}, 92C, 53-67.
Kwon, S. and Kim, Y. (2012). Large sample properties of the SCAD-penalized maximum likelihood estimation on high dimensions.
\emph{Statistica Sinica}, 629-653.
}
\seealso{
\code{\link{ncpen}}
}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee
}
