% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_cpp_wrap.R
\name{coef.ncpen}
\alias{coef.ncpen}
\title{coef.ncpen: extract the coefficients from an \code{ncpen} object}
\usage{
\method{coef}{ncpen}(object, ...)
}
\arguments{
\item{object}{(ncpen object) fitted \code{ncpen} object.}

\item{...}{other S3 parameters. Not used.}
}
\value{
\item{beta}{The coefficients matrix or list for \code{multinomial}.}
}
\description{
The function returns the coefficients matrix for all lambda values.
}
\examples{
### linear regression with scad penalty
sam =  sam.gen.ncpen(n=200,p=20,q=5,cf.min=0.5,cf.max=1,corr=0.5)
x.mat = sam$x.mat; y.vec = sam$y.vec
fit = ncpen(y.vec=y.vec,x.mat=x.mat)
coef(fit)
### multinomial regression with classo penalty
sam =  sam.gen.ncpen(n=200,p=20,q=5,k=3,cf.min=0.5,cf.max=1,corr=0.5,family="multinomial")
x.mat = sam$x.mat; y.vec = sam$y.vec
fit = ncpen(y.vec=y.vec,x.mat=x.mat,family="multinomial",penalty="classo")
coef(fit)
}
\references{
Lee, S., Kwon, S. and Kim, Y. (2016). A modified local quadratic approximation algorithm for penalized optimization problems.
\emph{Computational Statistics and Data Analysis}, 94, 275-286.
}
\seealso{
\code{\link{ncpen}}
}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee
}
