% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dv.plot.R
\name{dv.plot}
\alias{dv.plot}
\title{Plots drug plasma concentration vs time data}
\usage{
dv.plot(
  df,
  xvar = "Time",
  yvar = "Conc",
  obsLog = FALSE,
  myXlab = "Time",
  myYlab = "Concentration",
  color = NULL,
  group = NULL,
  guide = TRUE,
  onlyLin = FALSE,
  onlyLog = FALSE,
  XYlog = FALSE,
  STRATY = ".",
  STRATX = ".",
  myYBr = waiver(),
  myXBr = waiver(),
  myYBrLog = waiver(),
  myXBrLog = waiver(),
  myYlim = NULL,
  myXlim = NULL,
  myYlimLog = NULL,
  myXlimLog = NULL,
  title = NULL
)
}
\arguments{
\item{df}{A data frame to be used for the plot}

\item{xvar}{is the independent variable, default is \strong{"TIME"}}

\item{yvar}{is the dependent variable, default is \strong{"DV"}}

\item{obsLog}{is a logical variable (\code{TRUE}, \code{FALSE}). If
\code{TRUE}, concentration in observed data is assumed to be in logarithmic
scale. Default is \strong{\code{FALSE}}}

\item{myXlab}{is the x-axis label, default is \strong{"Time"}}

\item{myYlab}{is the y-axis label, defaults is \strong{"Concentration"}}

\item{color}{is the column name of the color stratification variable, e.g. 
"DOSEF". Default is \strong{NULL}}

\item{group}{is the column name of the variable used to group data, default
is \strong{"ID}}

\item{guide}{if \strong{TRUE}, show guide, default is \strong{TRUE}}

\item{onlyLin}{if \strong{TRUE}, presents only the linear version of the
plot, default is \strong{FALSE}}

\item{onlyLog}{if \strong{TRUE}, presents only the log version of the plot,
default is \strong{FALSE}}

\item{XYlog}{if \strong{TRUE}, both X and Y axes of the log version of the
plot is shown on the logarithmic scale; if \strong{FALSE}, only the Y-axis
is shown on the logarithmic scale. Default is \strong{FALSE}.}

\item{STRATY}{is the row stratification variable, default is \strong{"."}}

\item{STRATX}{is the column stratification variable, default is \strong{"."}}

\item{myYBr}{are the breaks for the Y-axis for the linear plot}

\item{myXBr}{are the breaks for the X-axis for the linear plot}

\item{myYBrLog}{are the breaks for the Y-axis for the log plot}

\item{myXBrLog}{are the breaks for the X-axis for the log plot}

\item{myYlim}{sets Y-axis limits for the linear plot}

\item{myXlim}{sets X-axis limits for the linear plot}

\item{myYlimLog}{sets the Y-axis limit for the log plot}

\item{myXlimLog}{sets the X-axis limit for the log plot}

\item{title}{The title of the plot.}
}
\value{
returns a graphical object created by arrangeGrob function
}
\description{
\pkg{dv.plot} plots DV vs Time data.
}
\details{
\pkg{dv.plot} plots DV vs Time data
}
