% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psofgwc.R
\name{psofgwc}
\alias{psofgwc}
\title{Fuzzy Geographicaly Weighted Clustering with Particle Swarm Optimization}
\usage{
psofgwc(
  data,
  pop = NA,
  distmat = NA,
  ncluster = 2,
  m = 2,
  distance = "euclidean",
  order = 2,
  alpha = 0.7,
  a = 1,
  b = 1,
  error = 1e-05,
  max.iter = 100,
  randomN = 0,
  vi.dist = "uniform",
  npar = 10,
  vmax = 0.7,
  pso.same = 10,
  c1 = 0.49,
  c2 = 0.49,
  w.inert = "sim.annealing",
  wmax = 0.9,
  wmin = 0.4,
  map = 0.4
)
}
\arguments{
\item{data}{an object of data with d>1. Can be \code{matrix} or \code{data.frame}. If your data is univariate, bind it with \code{1} to get a 2 columns.}

\item{pop}{an n*1 vector contains population.}

\item{distmat}{an n*n distance matrix between regions.}

\item{ncluster}{an integer. The number of clusters.}

\item{m}{degree of fuzziness or fuzzifier. Default is 2.}

\item{distance}{the distance metric between data and centroid, the default is euclidean, see \code{\link[rdist]{cdist}} for details.}

\item{order, }{minkowski order. default is 2.}

\item{alpha}{the old membership effect with [0,1], if \code{alpha} equals 1, it will be same as fuzzy C-Means, if 0, it equals to neighborhood effect.}

\item{a}{spatial magnitude of distance. Default is 1.}

\item{b}{spatial magnitude of population. Default is 1.}

\item{error}{error tolerance. Default is 1e-5.}

\item{max.iter}{maximum iteration. Default is 500.}

\item{randomN}{random seed for initialisation (if uij or vi is NA). Default is 0.}

\item{vi.dist}{a string of centroid population distribution between \code{'uniform'} (default) and \code{'normal'}. Can be defined as \code{vi.dist=} in \code{opt_param}.}

\item{npar}{number of particles. Can be defined as \code{npar=} in \code{opt_param}. Default is 10.}

\item{vmax}{maximum velocity to be tolerated. Can be defined as \code{vmax} in \code{opt_param}. Default is 0.7}

\item{pso.same}{number of consecutive unchange to stop the iteration. Can be defined as \code{same=} in \code{opt_param}.}

\item{c1}{Cognitive scaling parameters. Can be defined as \code{c1=} in \code{opt_param}. Default is 0.49}

\item{c2}{Social scaling parameters. Can be defined as \code{c2=} in \code{opt_param}. Default is 0.49,}

\item{w.inert}{The inertia weight update method between \code{"constant"}, \code{"chaotic"}, \code{"sim.annealing"}, \code{"nat.exponent1"}, \code{"nat.exponent2"} based on Bansal (2011). 
Can be defined as \code{type=} in \code{opt_param}. Default is \code{'sim.annealing'}}

\item{wmax}{Maximum inertia weight. Can be defined as \code{wmax} in \code{opt_param}. Default is 0.9.}

\item{wmin}{Minimum inertia weight. Can be defined as \code{wmin} in \code{opt_param}. Default is 0.4.}

\item{map}{Chaotic mapping parameter. Userful when \code{w.inert='chaotic'}. Can be defined as \code{map} in \code{opt_param}. Default is 0.4.}
}
\value{
an object of class \code{'fgwc'}.\cr
An \code{'fgwc'} object contains as follows:
\itemize{
\item \code{converg} - the process convergence of objective function
\item \code{f_obj} - objective function value
\item \code{membership} - membership matrix
\item \code{centroid} - centroid matrix
\item \code{validation} - validation indices (there are partition coefficient (\code{PC}), classification entropy (\code{CE}), 
SC index (\code{SC}), separation index (\code{SI}), Xie and Beni's index (\code{XB}), IFV index (\code{IFV}), and Kwon index (Kwon))
\item \code{max.iter} - Maximum iteration
\item \code{cluster} - the cluster of the data
\item \code{finaldata} - The final data (with the cluster)
\item \code{call} - the syntax called previously
\item \code{time} - computational time.
}
}
\description{
Fuzzy clustering with addition of spatial configuration of membership matrix with centroid optimization using Particle Swarm Algorithm.
}
\details{
Fuzzy Geographically Weighted Clustering (FGWC) was developed by \insertCite{fgwc;textual}{naspaclust} by adding 
neighborhood effects and population to configure the membership matrix in Fuzzy C-Means. Furthermore,
the Particle Swarm Optimization was developed by \insertCite{Kennedy1995;textual}{naspaclust} in order to get a more optimal solution of a certain complex function.
PSO was also improved by \insertCite{Bansal2011;textual}{naspaclust} by modifying the inertia weight. 
FGWC using PSO has been implemented previously by some studies \insertCite{fgwcpso,putra2017}{naspaclust}.
}
\examples{
data('census2010')
data('census2010dist')
data('census2010pop')
# First way
res1 <- psofgwc(census2010,census2010pop,census2010dist,3,2,'minkowski',4,npar=10)
# Second way
# initiate parameter
param_fgwc <- c(kind='v',ncluster=3,m=2,distance='minkowski',order=3,
               alpha=0.5,a=1.2,b=1.2,max.iter=1000,error=1e-6,randomN=10)
## tune the PSO parameter
pso_param <- c(vi.dist='uniform',npar=15,
         vmax=0.8, pso.same=10, c1=0.7, c2=0.6, type='chaotic',
                     wmax=0.8,wmin=0.3,map=0.3)
##FGWC with PSO
res2 <- fgwc(census2010,census2010pop,census2010dist,'pso',param_fgwc,pso_param)
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{fpafgwc}} \code{\link{gsafgwc}}
}
