//
// Copyright 2021 Staysail Systems, Inc. <info@staysail.tech>
// Copyright 2018 Capitar IT Group BV <info@capitoar.com>
//
// This software is supplied under the terms of the MIT License, a
// copy of which should be located in the distribution where this
// file was obtained (LICENSE.txt).  A copy of the license may also be
// found online at https://opensource.org/licenses/MIT.
//

#ifndef CORE_DEFS_H
#define CORE_DEFS_H

#include <stdint.h>

#define NNI_ARG_UNUSED(x) ((void) x)

#ifndef NDEBUG
#define NNI_ASSERT(x) \
	if (!(x))     \
	nni_panic("%s: %d: assert err: %s", __FILE__, __LINE__, #x)
#else
#define NNI_ASSERT(x) ((void)(0))
#endif

#define NNI_NUM_ELEMENTS(x) ((unsigned) (sizeof(x) / sizeof((x)[0])))

typedef nng_msg      nni_msg;
typedef nng_sockaddr nni_sockaddr;
typedef nng_url      nni_url;
typedef nng_iov      nni_iov;
typedef nng_aio      nni_aio;

typedef struct nni_socket   nni_sock;
typedef struct nni_ctx      nni_ctx;
typedef struct nni_dialer   nni_dialer;
typedef struct nni_listener nni_listener;
typedef struct nni_pipe     nni_pipe;

typedef struct nni_sp_tran         nni_sp_tran;
typedef struct nni_sp_dialer_ops   nni_sp_dialer_ops;
typedef struct nni_sp_listener_ops nni_sp_listener_ops;
typedef struct nni_sp_pipe_ops     nni_sp_pipe_ops;

typedef struct nni_proto_ctx_ops  nni_proto_ctx_ops;
typedef struct nni_proto_sock_ops nni_proto_sock_ops;
typedef struct nni_proto_pipe_ops nni_proto_pipe_ops;
typedef struct nni_proto          nni_proto;

typedef struct nni_plat_mtx nni_mtx;
typedef struct nni_plat_cv  nni_cv;
typedef struct nni_thr      nni_thr;
typedef void (*nni_thr_func)(void *);

typedef uint64_t nni_time;
typedef int32_t  nni_duration;

typedef void (*nni_cb)(void *);

#define NNI_TIME_NEVER ((nni_time) -1)
#define NNI_TIME_ZERO ((nni_time) 0)
#define NNI_SECOND (1000)

#define NNI_ALLOC_STRUCT(s) nni_zalloc(sizeof(*s))
#define NNI_FREE_STRUCT(s) nni_free((s), sizeof(*s))
#define NNI_ALLOC_STRUCTS(s, n) nni_zalloc(sizeof(*s) * n)
#define NNI_FREE_STRUCTS(s, n) nni_free(s, sizeof(*s) * n)

#define NNI_PUT16(ptr, u)                                      \
	do {                                                   \
		(ptr)[0] = (uint8_t) (((uint16_t) (u)) >> 8u); \
		(ptr)[1] = (uint8_t) ((uint16_t) (u));         \
	} while (0)

#define NNI_PUT32(ptr, u)                                       \
	do {                                                    \
		(ptr)[0] = (uint8_t) (((uint32_t) (u)) >> 24u); \
		(ptr)[1] = (uint8_t) (((uint32_t) (u)) >> 16u); \
		(ptr)[2] = (uint8_t) (((uint32_t) (u)) >> 8u);  \
		(ptr)[3] = (uint8_t) ((uint32_t) (u));          \
	} while (0)

#define NNI_PUT64(ptr, u)                                       \
	do {                                                    \
		(ptr)[0] = (uint8_t) (((uint64_t) (u)) >> 56u); \
		(ptr)[1] = (uint8_t) (((uint64_t) (u)) >> 48u); \
		(ptr)[2] = (uint8_t) (((uint64_t) (u)) >> 40u); \
		(ptr)[3] = (uint8_t) (((uint64_t) (u)) >> 32u); \
		(ptr)[4] = (uint8_t) (((uint64_t) (u)) >> 24u); \
		(ptr)[5] = (uint8_t) (((uint64_t) (u)) >> 16u); \
		(ptr)[6] = (uint8_t) (((uint64_t) (u)) >> 8u);  \
		(ptr)[7] = (uint8_t) ((uint64_t) (u));          \
	} while (0)

#define NNI_GET16(ptr, v)                               \
	v = (uint16_t) ((((uint16_t) ((uint8_t) (ptr)[0])) << 8u) + \
	    (((uint16_t) (uint8_t) (ptr)[1])))

#define NNI_GET32(ptr, v)                                \
	v = (((uint32_t) ((uint8_t) (ptr)[0])) << 24u) + \
	    (((uint32_t) ((uint8_t) (ptr)[1])) << 16u) + \
	    (((uint32_t) ((uint8_t) (ptr)[2])) << 8u) +  \
	    (((uint32_t) (uint8_t) (ptr)[3]))

#define NNI_GET64(ptr, v)                                \
	v = (((uint64_t) ((uint8_t) (ptr)[0])) << 56u) + \
	    (((uint64_t) ((uint8_t) (ptr)[1])) << 48u) + \
	    (((uint64_t) ((uint8_t) (ptr)[2])) << 40u) + \
	    (((uint64_t) ((uint8_t) (ptr)[3])) << 32u) + \
	    (((uint64_t) ((uint8_t) (ptr)[4])) << 24u) + \
	    (((uint64_t) ((uint8_t) (ptr)[5])) << 16u) + \
	    (((uint64_t) ((uint8_t) (ptr)[6])) << 8u) +  \
	    (((uint64_t) (uint8_t) (ptr)[7]))

#define NNI_INCPTR(ptr, n) ((ptr) = (void *) ((char *) (ptr) + (n)))

#define NNI_ALIGN_SIZE sizeof(void *)
#define NNI_ALIGN_MASK (NNI_ALIGN_SIZE - 1)
#define NNI_ALIGN_UP(sz) (((sz) + NNI_ALIGN_MASK) & ~NNI_ALIGN_MASK)

#define NNI_FLAG_IPV4ONLY 1

typedef enum {
	NNI_TYPE_OPAQUE,
	NNI_TYPE_BOOL,
	NNI_TYPE_INT32,
	NNI_TYPE_UINT32,
	NNI_TYPE_INT64,
	NNI_TYPE_UINT64,
	NNI_TYPE_SIZE,
	NNI_TYPE_DURATION,
	NNI_TYPE_STRING,
	NNI_TYPE_SOCKADDR,
	NNI_TYPE_POINTER,
} nni_type;

typedef nni_type nni_opt_type;

#ifndef NNI_MAX_MAX_TTL
#define NNI_MAX_MAX_TTL 15
#endif

#define NNI_MAX_HEADER_SIZE ((NNI_MAX_MAX_TTL + 1) * sizeof(uint32_t))

#ifndef NNI_EXPIRE_BATCH
#define NNI_EXPIRE_BATCH 100
#endif

#if __GNUC__ > 3
#define NNI_GCC_VERSION \
	(__GNUC__ * 10000 + __GNUC_MINOR__ * 100 + __GNUC_PATCHLEVEL__)
#endif

#endif
