% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constrainFun.R
\name{constrainFun}
\alias{constrainFun}
\title{Fix a Model Parameter and Conduct Likelihood Ratio Test}
\usage{
constrainFun(parameter.val, full, fm2, comp, G, mit = 600)
}
\arguments{
\item{parameter.val}{a value for which the log-Likelihood of a model is to
be calculated}

\item{full}{the full model \code{asreml} object}

\item{fm2}{starting values for the full model}

\item{comp}{which variance component to constrain}

\item{G}{logical, indicating if the component is part of the G structure}

\item{mit}{numeric, indicating maximum number of iterations for the
constrained asreml model}
}
\value{
A \code{vector} of length 1 returning either a \code{numeric} value
 corresponding to the likelihood ratio test statistic or else the missing 
 value indicator \code{NA}.
}
\description{
Given a model object from \code{asreml} and a range of estimates of the
parameter, the function will supply the likelihood ratio test statistic for
the comparison of the full model to one where the parameter of interest is
constrained.
}
\seealso{
See also \code{\link{LRTest}}
}
\author{
\email{matthewwolak@gmail.com}
}
