% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_learners.R
\name{lnr_logistic}
\alias{lnr_logistic}
\title{Standard Logistic Regression for Binary Classification}
\usage{
lnr_logistic(data, formula, weights = NULL, ...)
}
\arguments{
\item{data}{A dataframe to train a learner / learners on.}

\item{formula}{A regression formula to use inside this learner.}

\item{weights}{Observation weights; see \code{?lm}}

\item{...}{Any extra arguments that should be passed to the internal model
for model fitting purposes.}
}
\value{
A prediction function that accepts \code{newdata}, which returns
predictions for the probability of the outcome being 1/TRUE (a numeric
vector of values, one for each row of \code{newdata}).
}
\description{
A wrapper provided for convenience around \code{lnr_glm} that sets
\code{family = binomial(link = 'logit')}.
}
\examples{
lnr_logistic(mtcars, am ~ hp)(mtcars)
}
