% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learners.R
\name{learners}
\alias{learners}
\title{Learners in the \code{\{nadir\}} Package}
\description{
The following learners are available for continuous outcomes:
}
\details{
\itemize{
\item \code{lnr_mean}
\item \code{lnr_earth}
\item \code{lnr_gam}
\item \code{lnr_glm}
\item \code{lnr_glmer}
\item \code{lnr_glmnet}
\item \code{lnr_hal}
\item \code{lnr_lm}
\item \code{lnr_lmer}
\item \code{lnr_ranger}
\item \code{lnr_rf}
\item \code{lnr_xgboost}
}

See \code{?density_learners} to learn more about using conditional density
estimation in \code{nadir}.

\code{lnr_mean} is generally provided only for benchmarking purposes to compare
other learners against to ensure correct specification of learners, since any
prediction algorithm should (in theory) out-perform just using the mean of
the outcome for all predictions.

If you'd like to build a new learner, we recommend reading the
source code of several of the learners provided with \code{\{nadir\}} to
get a sense of how they should be specified.

A learner, as \code{\{nadir\}} understands them, is a function which
takes in \code{data}, a \code{formula}, possibly \code{...}, and
returns a function that predicts on its input \code{newdata}.

A simple example is reproduced here for ease of reference:
}
\examples{
 lnr_glm <- function(data, formula, weights = NULL, ...) {
  model <- stats::glm(formula = formula, data = data, weights = weights, ...)

  return(function(newdata) {
    predict(model, newdata = newdata, type = 'response')
  })
 }

}
\keyword{learners}
