% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_schemas.R
\name{cv_random_schema}
\alias{cv_random_schema}
\title{Assign Data to One of n_folds Randomly and Produce Training/Validation Data Lists}
\usage{
cv_random_schema(data, n_folds = 5)
}
\arguments{
\item{data}{a data.frame (or similar) to split into training and validation datasets.}

\item{n_folds}{The number of \code{training_data} and \code{validation_data} data frames to make.}
}
\value{
A list of two lists (\code{$training_data} and \code{$validation_data})
which are each lists of length \code{n_folds}. In each of those entries is a
data.frame that contains the nth training or validation fold of the data.
}
\description{
Each row in the data are assigned to one of \code{1:n_folds} at random.
Then for each of \code{i} in \code{1:n_folds}, the \code{training_data[[i]]}
is comprised of the data with \code{sl_fold != i}, i.e., capturing
roughly \code{(n-folds-1)/n_folds} proportion of the data.  The validation data
is a list of dataframes, each comprising of roughly \code{1/n_folds} proportion of the
data.
}
\details{
Since the assignment to folds is random, the proportions are not
exact or guaranteed and there is some variability in the size of
each \code{training_data} data frame, and likewise for the \code{validation_data}
data frames.
}
\examples{
  data(Boston, package = 'MASS')
  training_validation_data <- cv_random_schema(Boston, n_folds = 3)
  # take a look at what's in the output:
  str(training_validation_data, max.level = 2)
}
