% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screeners.R
\name{add_screener}
\alias{add_screener}
\title{Add a Screener to a Learner}
\usage{
add_screener(learner, screener, screener_extra_args = NULL)
}
\arguments{
\item{learner}{A learner to be modified by wrapping a screening stage on top of it.}

\item{screener}{A screener to be added on top of the learner}

\item{screener_extra_args}{Extra arguments to be passed to the screener}
}
\value{
A modified learner that when called on data and a formula
now runs a screening stage before fitting the learner and returning
a prediction function.
}
\description{
Add a Screener to a Learner
}
\examples{

# construct a learner where variables with less than .6 correlation are screened out
lnr_glm_with_cor_60_thresholding <-
  add_screener(
    learner = lnr_glm,
    screener = screener_cor,
    screener_extra_args = list(threshold = .6)
  )

# train that on the mtcars dataset — also checking that extra arguments are properly passed to glm
lnr_glm_with_cor_60_thresholding(mtcars, formula = mpg ~ ., family = "gaussian")(mtcars)

# if we've screened out variables with low correlation to mpg, one such variable is qsec,
# so changing qsec shouldn't modify the predictions from our learned algorithm
mtcars_but_qsec_is_changed <- mtcars
mtcars_but_qsec_is_changed$qsec <- rnorm(n = nrow(mtcars))

identical(
  lnr_glm_with_cor_60_thresholding(mtcars, formula = mpg ~ .)(mtcars),
  lnr_glm_with_cor_60_thresholding(mtcars, formula = mpg ~ .)(mtcars_but_qsec_is_changed)
 )

# earth version
lnr_earth_with_cor_60_thresholding <-
  add_screener(
    learner = lnr_earth,
    screener = screener_cor,
    screener_extra_args = list(threshold = .6)
  )
lnr_earth_with_cor_60_thresholding(mtcars, formula = mpg ~ .)(mtcars)

identical(
  lnr_earth_with_cor_60_thresholding(mtcars, formula = mpg ~ .)(mtcars),
  lnr_earth_with_cor_60_thresholding(mtcars, formula = mpg ~ .)(mtcars)
 )

# note that this 'test' does not pass for a learner like randomForest that has
# some randomness in its predictions.

}
