% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StaPLR.R
\name{StaPLR}
\alias{StaPLR}
\alias{staplr}
\title{Stacked Penalized Logistic Regression}
\usage{
StaPLR(
  x,
  y,
  view,
  view.names = NULL,
  family = "binomial",
  correct.for = NULL,
  alpha1 = 0,
  alpha2 = 1,
  relax = FALSE,
  nfolds = 10,
  na.action = "fail",
  na.arguments = NULL,
  seed = NULL,
  std.base = FALSE,
  std.meta = FALSE,
  ll1 = -Inf,
  ul1 = Inf,
  ll2 = 0,
  ul2 = Inf,
  cvloss = "deviance",
  metadat = "response",
  cvlambda = "lambda.min",
  cvparallel = FALSE,
  lambda.ratio = 1e-04,
  fdev = 0,
  penalty.weights.meta = NULL,
  penalty.weights.base = NULL,
  gamma.seq = c(0.5, 1, 2),
  parallel = FALSE,
  skip.version = TRUE,
  skip.meta = FALSE,
  skip.cv = FALSE,
  progress = TRUE,
  relax.base = FALSE,
  relax.meta = FALSE
)

staplr(
  x,
  y,
  view,
  view.names = NULL,
  family = "binomial",
  correct.for = NULL,
  alpha1 = 0,
  alpha2 = 1,
  relax = FALSE,
  nfolds = 10,
  na.action = "fail",
  na.arguments = NULL,
  seed = NULL,
  std.base = FALSE,
  std.meta = FALSE,
  ll1 = -Inf,
  ul1 = Inf,
  ll2 = 0,
  ul2 = Inf,
  cvloss = "deviance",
  metadat = "response",
  cvlambda = "lambda.min",
  cvparallel = FALSE,
  lambda.ratio = 1e-04,
  fdev = 0,
  penalty.weights.meta = NULL,
  penalty.weights.base = NULL,
  gamma.seq = c(0.5, 1, 2),
  parallel = FALSE,
  skip.version = TRUE,
  skip.meta = FALSE,
  skip.cv = FALSE,
  progress = TRUE,
  relax.base = FALSE,
  relax.meta = FALSE
)
}
\arguments{
\item{x}{input matrix of dimension nobs x nvars}

\item{y}{outcome vector of length nobs}

\item{view}{a vector of length nvars, where each entry is an integer describing to which view each feature corresponds.}

\item{view.names}{(optional) a character vector of length nviews specifying a name for each view.}

\item{family}{Either a character string representing one of the built-in families, or else a \code{glm()} family object. 
For more information, see \code{family} argument's documentation in \code{\link[glmnet]{glmnet}}. Note
that "multinomial", "mgaussian", "cox", or 2-column responses with "binomial" family are not yet supported.}

\item{correct.for}{(optional) a matrix with nrow = nobs, where each column is a feature which should be included directly into the meta.learner. By default these features are not penalized (see penalty.weights.meta) and appear at the top of the coefficient list.}

\item{alpha1}{(base) alpha parameter for glmnet: lasso(1) / ridge(0)}

\item{alpha2}{(meta) alpha parameter for glmnet: lasso(1) / ridge(0)}

\item{relax}{logical, whether relaxed lasso should be used at base and meta level.}

\item{nfolds}{number of folds to use for all cross-validation.}

\item{na.action}{character specifying what to do with missing values (NA). Options are "pass", "fail", "mean", "mice", and "missForest". Options "mice" and "missForest" requires the respective R package to be installed. Defaults to "pass".}

\item{na.arguments}{(optional) a named list of arguments to pass to the imputation function (e.g. to \code{mice} or \code{missForest}).}

\item{seed}{(optional) numeric value specifying the seed. Setting the seed this way ensures the results are reproducible even when the computations are performed in parallel.}

\item{std.base}{should features be standardized at the base level?}

\item{std.meta}{should cross-validated predictions be standardized at the meta level?}

\item{ll1}{lower limit(s) for each coefficient at the base-level. Defaults to -Inf.}

\item{ul1}{upper limit(s) for each coefficient at the base-level. Defaults to Inf.}

\item{ll2}{lower limit(s) for each coefficient at the meta-level. Defaults to 0 (non-negativity constraints). Does not apply to correct.for features.}

\item{ul2}{upper limit(s) for each coefficient at the meta-level. Defaults to Inf. Does not apply to correct.for features.}

\item{cvloss}{loss to use for cross-validation.}

\item{metadat}{which attribute of the base learners should be used as input for the meta learner? Allowed values are "response", "link", and "class".}

\item{cvlambda}{value of lambda at which cross-validated predictions are made. Defaults to the value giving minimum internal cross-validation error.}

\item{cvparallel}{whether to use 'foreach' to fit each CV fold (DO NOT USE, USE OPTION parallel INSTEAD).}

\item{lambda.ratio}{the ratio between the largest and smallest lambda value.}

\item{fdev}{sets the minimum fractional change in deviance for stopping the path to the specified value, ignoring the value of fdev set through glmnet.control. Setting fdev=NULL will use the value set through glmnet.control instead. It is strongly recommended to use the default value of zero.}

\item{penalty.weights.meta}{(optional) either a vector of length nviews containing different penalty factors for the meta-learner, or "adaptive" to calculate the weights from the data. The default value NULL implies an equal penalty for each view. The penalty factor is set to 0 for \code{correct.for} features.}

\item{penalty.weights.base}{(optional) either a list of length nviews, where each entry is a vector containing different penalty factors for each feature in that view, or "adaptive" to calculate the weights from the data. The default value NULL implies an equal penalty for each view. Note that using adaptive weights at the base level is generally only sensible if \code{alpha1} > 0.}

\item{gamma.seq}{a sequence of gamma values over which to optimize the adaptive weights. Only used when \code{penalty.weights.meta="adaptive"} or \code{penalty.weights.base="adaptive"}.}

\item{parallel}{whether to use foreach to fit the base-learners and obtain the cross-validated predictions in parallel. Executes sequentially unless a parallel backend is registered beforehand.}

\item{skip.version}{whether to skip checking the version of the glmnet package.}

\item{skip.meta}{whether to skip training the metalearner.}

\item{skip.cv}{whether to skip generating the cross-validated predictions.}

\item{progress}{whether to show a progress bar (only supported when parallel = FALSE).}

\item{relax.base}{logical indicating whether relaxed lasso should be employed for fitting the base learners. If \code{TRUE}, then CV is done with respect to the mixing parameter gamma as well as lambda.}

\item{relax.meta}{logical indicating whether relaxed lasso should be employed for fitting the meta learner. If \code{TRUE}, then CV is done with respect to the mixing parameter gamma as well as lambda.}
}
\value{
An object with S3 class "StaPLR".
}
\description{
Fit a two-level stacked penalized (logistic) regression model with a single base-learner and a single meta-learner. Stacked penalized regression models with a Gaussian or Poisson outcome can be fitted using the family argument.
}
\examples{
\donttest{
set.seed(012)
n <- 1000
cors <- seq(0.1,0.7,0.1)
X <- matrix(NA, nrow=n, ncol=length(cors)+1)
X[,1] <- rnorm(n)

for(i in 1:length(cors)){
  X[,i+1] <- X[,1]*cors[i] + rnorm(n, 0, sqrt(1-cors[i]^2))
}

beta <- c(1,0,0,0,0,0,0,0)
eta <- X \%*\% beta
p <- exp(eta)/(1+exp(eta))
y <- rbinom(n, 1, p) ## create binary response
view_index <- rep(1:(ncol(X)/2), each=2)

# Stacked penalized logistic regression
fit <- StaPLR(X, y, view_index)
coef(fit)$meta

new_X <- matrix(rnorm(16), nrow=2)
predict(fit, new_X)

# Stacked penalized linear regression
y <- eta + rnorm(100) ## create continuous response
fit <- StaPLR(X, y, view_index, family = "gaussian")
coef(fit)$meta
coef(fit)$base
new_X <- matrix(rnorm(16), nrow=2)
predict(fit, new_X)

# Stacked penalized Poisson regression
y <- ceiling(eta + 4) ## create count response
fit <- StaPLR(X, y, view_index, family = "poisson")
coef(fit)$meta
coef(fit)$base
new_X <- matrix(rnorm(16), nrow=2)
predict(fit, new_X)
}
}
\author{
Wouter van Loon <w.s.van.loon@fsw.leidenuniv.nl>
}
\keyword{TBA}
