% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{PSII}
\alias{PSII}
\title{Random Generation for the Spherically Symmetric Pearson Type II Distribution}
\usage{
PSII(n, p, s)
}
\arguments{
\item{n}{number of rows (observations).}

\item{p}{number of columns (variables).}

\item{s}{shape parameter, \eqn{s>-1}.}
}
\value{
Returns univariate (\eqn{p=1}) or multivariate (\eqn{p>1}) random sample matrix.
}
\description{
Generate univariate or multivariate random sample for the spherically symmetric Pearson type II distribution.
}
\examples{
set.seed(12345)

## Generate 5X2 random sample matrix from PSII(s=1) ##
PSII(n=5, p=2, s=1)


## Power calculation against bivariate (p=2) PSII(s=1) distribution ##
## at sample size n=50 at one-sided alpha = 0.05 ##

# Zhou-Shao's test #
power.mvnTest(a = 0.05, n = 50, p = 2,  B = 100, FUN = PSII, s = 1)

}
\references{
Kotz, S. (1975). Multivariate distributions at a cross road. In A Modern Course on Statistical Distributions in Scientific Work (pp. 247-270). Springer, Dordrecht.

Henze, N., & Zirkler, B. (1990). A class of invariant consistent tests for multivariate normality. \emph{Communications in statistics-Theory and Methods}, 19(10), 3595-3617.
}
