% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acf.R
\name{acf.calc}
\alias{acf.calc}
\title{Autocorrelation function}
\usage{
acf.calc(data.mat, lag = 50, plot = TRUE, title = NULL, details = FALSE)
}
\arguments{
\item{data.mat}{matrix including the variables of which autocorrelations are calculated.}

\item{lag}{lag at which the autocorrelation is calculated, default is set as 50.}

\item{plot}{logical variable to specify whether the plot is generated, default is set to TRUE.}

\item{title}{title of each generated autocorrelation plot.}

\item{details}{boolean variable to specify whether the autocorrelation values are returned, default is set to FALSE.}
}
\value{
If \code{details} = TRUE, a matrix containing the calculated autocorrelations of all the variables in the dataset will be returned.
If \code{plot} = TRUE, the autocorrelation plots of all the variables will be drawn.
}
\description{
Calculates the autocorrelation function and draws the plots.
}
\details{
This function calculates the autocorrelations of all the variables on a column by column base.
The default value of \code{lag} is set as 50, the maximum number of lag should not exceed the number of rows of the dataset,
which reflects the corresponding number of iteration of running the multiple imputation.
}
\examples{

### generate some data
dat <- MASS::mvrnorm(n = 1000, mu = c(1, 2, 3, 4), Sigma = diag(4))

### ACF plots
acf.calc(data.mat = dat, title = paste0("Var ", 1:nrow(dat)))

}
