% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutation_types.R
\name{mutation_types_convert_pave_to_maf}
\alias{mutation_types_convert_pave_to_maf}
\title{Convert PAVE Mutation Types to MAF}
\usage{
mutation_types_convert_pave_to_maf(
  pave_mutation_types,
  variant_type = NULL,
  split_on_ampersand = TRUE,
  missing_to_silent = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{pave_mutation_types}{a vector of PAVE terms you want to convert to MAF variant classifications (character)}

\item{variant_type}{a vector describing each mutations type. Valid elements include: "SNP", "DNP", "TNP", "ONP", "DEL", "INS". Used to map frameshift_variant to more specific MAF columns (character)}

\item{split_on_ampersand}{should '&' separated PAVE terms be automatically converted to single PAVE terms based on highest severity? (flag)}

\item{missing_to_silent}{should missing (NA) or empty ('') mutation types be converted to 'Silent' mutations?}

\item{verbose}{verbose (flag)}
}
\value{
matched MAF variant classification terms (character)
}
\description{
Convert PAVE Mutation Types to MAF
}
\examples{
mutation_types_convert_pave_to_maf(
  c('upstream_gene_variant', 'stop_lost', 'splice_acceptor_variant')
)
}
