% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection.R
\name{project_onto}
\alias{project_onto}
\alias{match_flat}
\title{Closest point on a given flat}
\usage{
project_onto(
  set,
  target_rows,
  ineqmat = NULL,
  start_zero = TRUE,
  edo = 12,
  rounder = 10
)

match_flat(
  set,
  target_scale,
  start_zero = TRUE,
  ineqmat = NULL,
  edo = 12,
  rounder = 10
)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{target_rows}{An integer vector: each integer specifies a row
of \code{ineqmat} which helps to determine the target flat. The
rows must be linearly independent.}

\item{ineqmat}{Specifies which hyperplane arrangement to consider. By default (or by
explicitly entering "mct") it supplies the standard "Modal Color Theory" arrangements
of \code{\link[=getineqmat]{getineqmat()}}, but can be set to strings "white," "black", "gray", "roth", "infrared",
"pastel", "rosy", "infrared", or "anaglyph", giving the \code{ineqmat}s of \code{\link[=make_white_ineqmat]{make_white_ineqmat()}},
\code{\link[=make_black_ineqmat]{make_black_ineqmat()}}, \code{\link[=make_gray_ineqmat]{make_gray_ineqmat()}}, \code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}},
\code{\link[=make_infrared_ineqmat]{make_infrared_ineqmat()}}, \code{\link[=make_pastel_ineqmat]{make_pastel_ineqmat()}}, \code{\link[=make_rosy_ineqmat]{make_rosy_ineqmat()}},
\code{\link[=make_infrared_ineqmat]{make_infrared_ineqmat()}}, or \code{\link[=make_anaglyph_ineqmat]{make_anaglyph_ineqmat()}}. For other
arrangements, this parameter accepts explicit matrices.}

\item{start_zero}{Boolean: should the result be transposed so that its pitch
initial is zero? Defaults to \code{TRUE}.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}

\item{target_scale}{A numeric vector which represents a scale
on the target flat.}
}
\value{
A numeric vector of same length as \code{set}, representing
the projection of \code{set} onto the flat determined by \code{target_rows} or
\code{target_scale}.
}
\description{
Projects a scale onto the nearest point that lies on a target flat
of the hyperplane arrangement. \code{project_onto()} determines the target
flat from a list of linearly independent rows in \code{ineqmat} which define
the flat. \code{match_flat()} determines the target by extrapolating from a
given scale on that flat. Note that while the projection lies on
the desired flat (i.e. it will have all of the necessary \code{0}s in its
sign vector), it will not necessarily belong to any particular \emph{color}.
(That is, projection doesn't give you control over the \code{1}s and \code{-1}s of
the sign vector.)
}
\examples{
minor_triad <- c(0, 3, 7)
project_onto(minor_triad, 3)
project_onto(minor_triad, 1)
project_onto(minor_triad, c(1, 3))
# This last projection results in the perfectly even scale
# because that's the only scale on both hyperplanes 1 and 3.

major_scale <- c(0, 2, 4, 5, 7, 9, 11)
projected_just_dia <- match_flat(j(dia), major_scale)
print(projected_just_dia)

# This is very close to fifth-comma meantone:
fifth_comma_meantone <- sim(sort(((0:6) * meantone_fifth(1/5))\%\%12))[,5]
vl_dist(projected_just_dia, fifth_comma_meantone)
}
