% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVR.r
\name{sensitivity.analysis}
\alias{sensitivity.analysis}
\title{Sensitivity Analysis}
\usage{
sensitivity.analysis(
  in.mat,
  in.com,
  breaks,
  out.pdf,
  in.traitspaces = "use data"
)
}
\arguments{
\item{in.mat}{A record x trait matrix}

\item{in.com}{A community x record matrix}

\item{breaks}{A list containing break points to use for each trait. Categorical
traits are unmodified, and should be a list containing the text "cat" and the number of categories.
e.g., list("cat",2). For non-categorical traits, this list needs to contain the same number
of elements for each trait. See example below for format.}

\item{out.pdf}{A pdf to be created containing the results of the sensitivity analysis.
"none" plots to the active R window. "no.plot" will disable the plot entirely.}

\item{in.traitspaces}{a vector of trait spaces, if pre-existing trait spaces are desired. Otherwise, 
the default of 'use data' will calculate traitspaces based on the range of values present in the data.}
}
\description{
Run a sensitivity analysis on the data to see to what extent richness is sensitive to choice
of break points.
}
\examples{
# Example of a sensitivity analysis using simulated traits

# Set up example
#Adding 0.5 is to give even probabilities when rounding
n.recs = 10
tr1 = round(runif(n.recs,1 - 0.5, 10 +0.5),0) 
tr2 = round(runif(n.recs,1 - 0.5, 4 + 0.5),0)

# Set up row & col names
row.nams = sprintf("Record_\%s", seq(1,n.recs))
col.nams = c("tr1","tr2")

#Create matrix
in.mat = matrix(c(tr1,tr2), ncol = 2, dimnames = list(row.nams, col.nams))

# Get break points
tr1.breaks = get.breaks(1,10)
tr2.breaks = get.breaks(1,4)
tr2.breaks = expand.breaks(tr2.breaks, 9)

breaks = list(tr1.breaks, tr2.breaks)

# Actually run sensitivity analysis
# Note that the plot & results will vary as this depends on random numbers
results = sensitivity.analysis(in.mat,"none", breaks, "none")

}
