% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalsize.R
\name{finalsize}
\alias{finalsize}
\title{Calculate final outbreak size or distribution of a multigroup transmission model for a given basic
reproduction number, contact/transmission assumptions, and initial conditions}
\usage{
finalsize(
  popsize,
  R0,
  contactmatrix,
  relsusc,
  reltransm,
  initR,
  initI,
  initV,
  method = "ODE",
  nsims = 1
)
}
\arguments{
\item{popsize}{the population size of each group}

\item{R0}{the basic reproduction number}

\item{contactmatrix}{matrix of group-to-group contact rates}

\item{relsusc}{relative susceptibility to infection per contact of each group}

\item{reltransm}{relative transmissibility per contact of each group}

\item{initR}{initial number of each group already infected and removed (included in size result)}

\item{initI}{initial number of each group infectious}

\item{initV}{initial number of each group vaccinated}

\item{method}{the method of final size calculation or simulation to use}

\item{nsims}{the number of simulations to run for stochastic methods}
}
\value{
a vector (nsims = 1) or matrix (nsims > 1) with the final number infected from each group (column) in each simulation (row)
}
\description{
Calculate final outbreak size or distribution of a multigroup transmission model for a given basic
reproduction number, contact/transmission assumptions, and initial conditions
}
\examples{
popsize <- c(800, 200)
R0 <- 2
contactmatrix <- contactMatrixPropPref(popsize = popsize, contactrate = c(1, 1),
ingroup = c(0.2, 0.2))
relsusc <- c(1, 1)
reltransm <- c(1, 1)
initR <- c(0, 0)
initI <- c(1, 0)
initV <- 0.2 * popsize
# Default method "ODE" numerical solves ordinary differential equations until infectious count
# is close to 0
finalsize(popsize, R0, contactmatrix, relsusc, reltransm, initR, initI, initV)
finalsize(popsize, R0, contactmatrix, relsusc, reltransm, initR, initI, initV,
method = "analytic")
finalsize(popsize, R0, contactmatrix, relsusc, reltransm, initR, initI, initV,
method = "stochastic", nsims = 10)
# All "escaped" outbreaks set to deterministic final size:
finalsize(popsize, R0, contactmatrix, relsusc, reltransm, initR, initI, initV,
method = "hybrid", nsims = 10)
}
