% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_summary.R
\name{summary.multifanova}
\alias{summary.multifanova}
\title{Print "multifanova" object}
\usage{
\method{summary}{multifanova}(object, ...)
}
\arguments{
\item{object}{a "multifanova" object.}

\item{...}{integer indicating the number of decimal places to be used to present the numerical results.
It can be named \code{digits} as in the \code{round()} function (see examples).}
}
\value{
No return value, called for side effects.
}
\description{
Prints the summary of the global and multiple contrasts testing for functional data.
}
\details{
The function prints out the information about the number of samples,
number of observations in each sample, number of design time points, contrasts used,
test statistics, critical values, \eqn{p}-values of tests performed by the
\code{multiFANOVA()} function. It also gives the decisions.
}
\examples{
# Some of the examples may run some time.

# Canadian weather data set
# There are three samples of mean temperatures for
# fifteen weather stations in Eastern Canada,
# another fifteen in Western Canada, and
# the remaining five in Northern Canada.
library(fda)
data_set <- t(CanadianWeather$dailyAv[,, "Temperature.C"])
k <- 3
gr_label <- rep(c(1, 2, 3), c(15, 15, 5))
\donttest{
# Tukey's contrast matrix
h_tukey <- GFDmcv::contr_mat(k, type = "Tukey")
# testing without parallel computing
res <- multiFANOVA(data_set, gr_label, h_tukey)
summary(res, digits = 3)}
\dontshow{
h_tukey <- GFDmcv::contr_mat(k, type = "Tukey")
res <- multiFANOVA(data_set[, 1:10], gr_label, h_tukey, n_boot = 3)
summary(res, digits = 3)}

}
