% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mue_rr.R
\name{mue_rr}
\alias{mue_rr}
\title{Calculate relative risk based on ratio of median unbiased estimators.}
\usage{
mue_rr(n1, y1, n2, y2, alpha = 0.05)
}
\arguments{
\item{n1}{Sample size for group 1.}

\item{y1}{Number of events in group 1.}

\item{n2}{Sample size for group 2.}

\item{y2}{Number of events in group 2.}

\item{alpha}{The significance level for the confidence interval. Default value is 0.05.}
}
\value{
A dataframe with the various components generated during the estimation along with the MUE-based estimate of the relative risk.
}
\description{
This function calculates an estimate of relative risk based on the ratio of two median unbiased estimates of proportions based on the work by \href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC2918902/}{Carter et al (2010)}.  The relative risk will be in the order of Pr(Group 1) / Pr(Group 2).
}
\examples{
mue_rr(9,1,11,0)
mue_rr(9,1,11,0,0.05)
mue_rr(3,0,4,0,0.05)
mue_rr(12,1,15,1,0.15)
}
