% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_evd.R
\name{evd}
\alias{evd}
\alias{evd,mrgmod-method}
\alias{evd,missing-method}
\alias{evd,ev-method}
\alias{as.evd}
\title{Create an event object with data-like names}
\usage{
evd(x, ...)

\S4method{evd}{mrgmod}(x, ...)

\S4method{evd}{missing}(x, ...)

\S4method{evd}{ev}(x, ...)

as.evd(x)
}
\arguments{
\item{x}{an event object.}

\item{...}{arguments passed to \code{\link[=ev]{ev()}}.}
}
\description{
This function calls \code{\link[=ev]{ev()}} to create an event object and then sets the
case attribute so that it renders nmtran data names in upper case. An
object created with \code{\link[=evd]{evd()}} can be used in the same way as an object
created with \code{\link[=ev]{ev()}}.
}
\details{
Note that \code{evd} isn't a separate class; it is just an \code{ev} object with
a specific \code{case} attribute. See examples which illustrate the difference.
}
\examples{
a <- evd(amt = 100)
b <- ev(amt = 300)
a
as.data.frame(a)
as_data_set(a, b)
as_data_set(b, a)
as.data.frame(seq(a, b))

}
\seealso{
\code{\link[=ev]{ev()}}, \code{\link[=lctran]{lctran()}}, \code{\link[=uctran]{uctran()}}
}
