% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{list_md_active_accounts}
\alias{list_md_active_accounts}
\title{List active MotherDuck accounts}
\usage{
list_md_active_accounts(motherduck_token = "MOTHERDUCK_TOKEN")
}
\arguments{
\item{motherduck_token}{Character. Either the name of an environment variable containing your
MotherDuck access token (default \code{"MOTHERDUCK_TOKEN"}) or the token itself.}
}
\value{
A tibble with two columns:
\itemize{
\item \code{account_settings}: configuration keys for the active accounts.
\item \code{account_values}: corresponding configuration values.
}
}
\description{
Retrieves a list of active MotherDuck accounts available to the authenticated
user, returning the results as a tidy tibble.
}
\details{
This function queries the MotherDuck REST API endpoint
(\verb{https://api.motherduck.com/v1/active_accounts}) using the provided or
environment-resolved authentication token.
The current user name is also displayed via \code{\link[=show_current_user]{show_current_user()}}.
}
\examples{
\dontrun{
# Retrieve active accounts for the authenticated user
accounts_tbl <- list_md_active_accounts()
print(accounts_tbl)
}

}
\seealso{
Other db-api: 
\code{\link{configure_md_user_settings}()},
\code{\link{create_md_access_token}()},
\code{\link{create_md_user}()},
\code{\link{delete_md_access_token}()},
\code{\link{delete_md_user}()},
\code{\link{list_md_user_instance}()},
\code{\link{list_md_user_tokens}()},
\code{\link{show_current_user}()}
}
\concept{db-api}
