% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{delete_schema}
\alias{delete_schema}
\title{Drop a Schema from a Database}
\usage{
delete_schema(.con, database_name, schema_name, cascade = FALSE)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{database_name}{Name of the database containing the schema.}

\item{schema_name}{Name of the schema to drop.}

\item{cascade}{Logical; if \code{TRUE} (default), use \code{CASCADE} to drop
all dependent objects in the schema. If \code{FALSE}, drop only if empty.}
}
\value{
Invisibly returns \code{NULL}.
Side effect: drops the schema (and contained objects if \code{cascade = TRUE})
and prints CLI status.
}
\description{
Drops a schema from a specified database.
Optionally cascades the deletion to all objects within the schema.
Prints helpful CLI information about the current connection and action.
}
\details{
\itemize{
\item Runs \verb{DROP SCHEMA IF EXISTS <db>.<schema>} with optional \code{CASCADE}.
\item Intended for DuckDB or MotherDuck connections.
\item Uses CLI helpers to show current connection and report the deletion.
}
}
\seealso{
Other db-manage: 
\code{\link{alter_table_schema}()},
\code{\link{copy_tables_to_new_location}()},
\code{\link{create_database}()},
\code{\link{create_if_not_exists_share}()},
\code{\link{create_or_replace_share}()},
\code{\link{create_schema}()},
\code{\link{create_table}()},
\code{\link{delete_and_create_schema}()},
\code{\link{delete_database}()},
\code{\link{delete_table}()},
\code{\link{describe_share}()},
\code{\link{drop_share}()},
\code{\link{list_owned_shares}()},
\code{\link{list_shared_with_me_shares}()},
\code{\link{upload_database_to_md}()}
}
\concept{db-manage}
