% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppc.R, R/ppc.reproFitTT.R,
%   R/ppc.survFitCstExp.R, R/ppc.survFitPredict_Nsurv.R, R/ppc.survFitTKTD.R,
%   R/ppc.survFitTT.R, R/ppc.survFitVarExp.R
\name{ppc}
\alias{ppc}
\alias{ppc.reproFitTT}
\alias{ppc.survFitCstExp}
\alias{ppc.survFitPredict_Nsurv}
\alias{ppc.survFitTKTD}
\alias{ppc.survFitTT}
\alias{ppc.survFitVarExp}
\title{Posterior predictive check plot}
\usage{
ppc(x, ...)

\method{ppc}{reproFitTT}(
  x,
  style = "ggplot",
  xlab = "Observed Cumul. Nbr. of offspring",
  ylab = "Predicted Cumul. Nbr. of offspring",
  main = NULL,
  ...
)

\method{ppc}{survFitCstExp}(x, style = "ggplot", main = NULL, ...)

\method{ppc}{survFitPredict_Nsurv}(
  x,
  xlab = "Observed nb of survivors",
  ylab = "Predicted nb of survivors",
  main = NULL,
  ...
)

\method{ppc}{survFitTKTD}(x, style = "ggplot", main = NULL, ...)

\method{ppc}{survFitTT}(x, style = "ggplot", main = NULL, ...)

\method{ppc}{survFitVarExp}(
  x,
  xlab = "Observed nb of survivors",
  ylab = "Predicted nb of survivors",
  main = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{survFitVarExp}}

\item{\dots}{Further arguments to be passed to generic methods}

\item{style}{graphical backend, can be \code{'generic'} or \code{'ggplot'}}

\item{xlab}{A label for the \eqn{X}-axis, by default \code{Observed nb of survivors}.}

\item{ylab}{A label for the \eqn{Y}-axis, by default \code{Predicted nb of survivors}.}

\item{main}{A main title for the plot.}
}
\value{
a plot of class \code{ggplot}

a plot of class \code{ggplot}

a plot of class \code{ggplot}

a plot of class \code{ggplot}

a plot of class \code{ggplot}

a plot of class \code{ggplot}

a plot of class \code{ggplot}
}
\description{
Plots posterior predictive check for \code{reproFitTT}, \code{survFitTT},
 \code{survFitTKTD}, \code{survFitCstExp} and \code{survFitVarExp} objects.

This is the generic \code{ppc} S3 method for the \code{reproFitTT} class.
It plots the predicted values with 95\% credible intervals versus the observed
values.

This is the generic \code{ppc} S3 method for the \code{survFitCstExp} class. It
plots the predicted values along with 95\% credible intervals
versus the observed values for \code{survFit} objects.

This is the generic \code{ppc} S3 method for the \code{survFitPredict_Nsurv} class. It
plots the predicted values along with 95\% credible intervals
versus the observed values for \code{survFitPredict_Nsurv} objects.

This is the generic \code{ppc} S3 method for the \code{survFitTKTD} class. It
plots the predicted values along with 95\% credible intervals
versus the observed values for \code{survFitTKTD} objects.

This is the generic \code{ppc} S3 method for the \code{survFitTT} class. It
plots the predicted values with 95 \% credible intervals versus the observed
values for \code{survFitTT} objects.

This is the generic \code{ppc} S3 method for the \code{survFitVarExp} class. It
plots the predicted values along with 95\% credible intervals
versus the observed values for \code{survFit} objects.
}
\details{
Depending on the class of the object \code{x} see their links. 
for class \code{reproFitTT}: \link[=ppc.reproFitTT]{ppc.reproFitTT} ;  
for class \code{survFitTT}: \link[=ppc.survFitTT]{ppc.survFitTT} ; 
for class \code{survFitTKTD}: \link[=ppc.survFitTKTD]{ppc.survFitTKTD} ;
for class \code{survFitCstExp}: \link[=ppc.survFitCstExp]{ppc.survFitCstExp} and
for class \code{survFitVarExp}: \link[=ppc.survFitVarExp]{ppc.survFitVarExp}.

The coordinates of black points are the observed values of the cumulated number
of reproduction outputs for a given concentration (\eqn{X}-scale) and the corresponding 
predicted values (\eqn{Y}-scale). 95\% prediction intervals are added to each predicted
value, colored in green if this interval contains the observed value and in red
in the other case. As replicates are not pooled in this plot, overlapped points
are shifted on the \eqn{X-}axis to help the visualization of replicates. The bisecting
line (y = x) is added to the plot in order to see if each prediction interval
contains each observed value. As replicates are shifted on the \eqn{X}-axis, this
line may be represented by steps.

The black points show the observed number of survivors (pooled
replicates, on \eqn{X}-axis) against the corresponding predicted
number (\eqn{Y}-axis). Predictions come along with 95\% prediction
intervals, which are depicted in green when they contain the
observed value and in red otherwise. Samples with equal observed
value are shifted on the \eqn{X}-axis. For that reason, the
bisecting line (y = x), is represented by steps when observed
values are low. That way we ensure green intervals do intersect the
bisecting line.

For \code{survFitPredict_Nsurv} object, PPC is based on times series simulated
for each replicate. In addition, the black points show the observed
 number of survivors (on \eqn{X}-axis)
 against the corresponding predicted
number (\eqn{Y}-axis). Predictions come along with 95\% prediction
intervals, which are depicted in green when they contain the
observed value and in red otherwise.

The black points show the observed number of survivors (pooled
replicates, on \eqn{X}-axis) against the corresponding predicted
number (\eqn{Y}-axis). Predictions come along with 95\% prediction
intervals, which are depicted in green when they contain the
observed value and in red otherwise. Samples with equal observed
value are shifted on the \eqn{X}-axis. For that reason, the
bisecting line (y = x), is represented by steps when observed
values are low. That way we ensure green intervals do intersect the
bisecting line.

The coordinates of black points are the observed values of the number of survivors
(pooled replicates) for a given concentration (\eqn{X}-axis) and the corresponding 
predicted values (\eqn{Y}-axis). 95\% prediction intervals are added to each predicted
value, colored in green if this interval contains the observed value and in red
otherwise.
The bisecting line (y = x) is added to the plot in order to see if each
prediction interval contains each observed value. As replicates are shifted
on the x-axis, this line is represented by steps.

The black points show the observed number of survivors (on \eqn{X}-axis)
 against the corresponding predicted
number (\eqn{Y}-axis). Predictions come along with 95\% prediction
intervals, which are depicted in green when they contain the
observed value and in red otherwise.
}
