############################
# CREATION OF FIXTURE OBJECT
############################

library(testthat)
library(morseTKTD)

################## CONSTANT EXPOSURE PROFILE

data("propiconazole")
# INFERENCE
cPRZ <- morseTKTD::survData(propiconazole)
cPRZ_SDfit <- morseTKTD::fit(cPRZ, model_type = "SD")
cPRZ_ITfit <- morseTKTD::fit(cPRZ, model_type = "IT")
saveRDS(cPRZ_SDfit, test_path("fixtures", "cPRZ_SDfit.rds"))
saveRDS(cPRZ_ITfit, test_path("fixtures", "cPRZ_ITfit.rds"))

# PREDICTION
cPRZ_ITfit <- readRDS(test_path("fixtures", "cPRZ_ITfit.rds"))
cPRZ_SDfit <- readRDS(test_path("fixtures", "cPRZ_SDfit.rds"))
cPRZ_SDpred <- predict(cPRZ_SDfit)
saveRDS(cPRZ_SDpred, test_path("fixtures", "cPRZ_SDpred.rds"))
cPRZ_ITpred <- predict(cPRZ_ITfit)
saveRDS(cPRZ_ITpred, test_path("fixtures", "cPRZ_ITpred.rds"))
cPRZ_SDpred100 <- predict(cPRZ_SDfit, interpolate_length = 100)
saveRDS(cPRZ_SDpred100, test_path("fixtures", "cPRZ_SDpred100.rds"))
cPRZ_ITpred100 <- predict(cPRZ_ITfit, interpolate_length = 100)
saveRDS(cPRZ_ITpred100, test_path("fixtures", "cPRZ_ITpred100.rds"))
# LCX
cPRZ_ITlcxt <- lcxt(cPRZ_ITfit)
cPRZ_SDlcxt <- lcxt(cPRZ_SDfit)
saveRDS(cPRZ_ITlcxt, test_path("fixtures", "cPRZ_ITlcxt.rds"))
saveRDS(cPRZ_SDlcxt, test_path("fixtures", "cPRZ_SDlcxt.rds"))
# PPC
cPRZ_ITppc <- ppc(cPRZ_ITfit)
cPRZ_SDppc <- ppc(cPRZ_SDfit)
saveRDS(cPRZ_ITppc, test_path("fixtures", "cPRZ_ITppc.rds"))
saveRDS(cPRZ_SDppc, test_path("fixtures", "cPRZ_SDppc.rds"))
# LPX

################## VARIABLE EXPOSURE PROFILE

data("propiconazole_pulse_exposure")
# INFERENCE
vPRZ <- morseTKTD::survData(propiconazole_pulse_exposure)
options(mc.cores = 2)
vPRZ_SDfit <- morseTKTD::fit(vPRZ, model_type = "SD")
saveRDS(vPRZ_SDfit, test_path("fixtures", "vPRZ_SDfit.rds"))
vPRZ_ITfit <- morseTKTD::fit(vPRZ, model_type = "IT")
saveRDS(vPRZ_ITfit, test_path("fixtures", "vPRZ_ITfit.rds"))

# PREDICTION
vPRZ_ITfit <- readRDS(test_path("fixtures", "vPRZ_ITfit.rds"))
vPRZ_SDfit <- readRDS(test_path("fixtures", "vPRZ_SDfit.rds"))

vPRZ_SDpred <- predict(vPRZ_SDfit)
vPRZ_ITpred <- predict(vPRZ_ITfit)
saveRDS(vPRZ_SDpred, test_path("fixtures", "vPRZ_SDpred.rds"))
saveRDS(vPRZ_ITpred, test_path("fixtures", "vPRZ_ITpred.rds"))

vPRZ_SDpred100 <- predict(vPRZ_SDfit, interpolate_length = 100)
vPRZ_ITpred100 <- predict(vPRZ_ITfit, interpolate_length = 100)
saveRDS(vPRZ_SDpred100, test_path("fixtures", "vPRZ_SDpred100.rds"))
saveRDS(vPRZ_ITpred100, test_path("fixtures", "vPRZ_ITpred100.rds"))

# LCX
vPRZ_ITlcxt <- lcxt(vPRZ_ITfit)
vPRZ_SDlcxt <- lcxt(vPRZ_SDfit)
saveRDS(vPRZ_ITlcxt, test_path("fixtures", "vPRZ_ITlcxt.rds"))
saveRDS(vPRZ_SDlcxt, test_path("fixtures", "vPRZ_SDlcxt.rds"))

