% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-SurvPredict.R
\name{PlotPredictSurvFit}
\alias{PlotPredictSurvFit}
\alias{plot.SurvPredict}
\title{Plotting method for \code{SurvPredict} objects}
\usage{
\method{plot}{SurvPredict}(
  x,
  xlab = "Time",
  ylab = "Number of Survival",
  main = "Survival Probability with 95\% Credible Interval",
  background_concentration = FALSE,
  add_legend = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{SurvPredict}}

\item{xlab}{argument for the label of the x-axis}

\item{ylab}{argument for the label of the y-axis}

\item{main}{argument for the title of the graphic}

\item{background_concentration}{Binary. If TRUE (default is FALSE), it print the
background exposure profile.}

\item{add_legend}{add legend to the plot, default is \code{FALSE}}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
an object of class \code{ggplot}, see function \code{\link[ggplot2]{ggplot}}
}
\description{
This is the generic \code{plot} S3 method for the \code{SurvPredict} class. It
plots concentration-response fit under target time survival analysis.
}
\keyword{plot}
