% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{is_interaction_model}
\alias{is_interaction_model}
\title{Check if model object has interaction terms}
\usage{
is_interaction_model(object)
}
\arguments{
\item{object}{An object of class \code{modsem_pi} or \code{modsem_da},
respectively.}
}
\value{
Logical. \code{TRUE} if the model has an interaction term,
  otherwise it returns \code{FALSE}.
}
\description{
Check if model object has interaction terms
}
\examples{
m1 <- '
# Outer Model
  X =~ x1 + x2 + x3
  Z =~ z1 + z2 + z3
  Y =~ y1 + y2 + y3

# Inner Model
  Y ~ X + Z + X:Z
'

est_dca <- modsem(m1, oneInt, method = "dblcent")
is_interaction_model(est_dca)

\dontrun{
est_lms <- modsem(m1, oneInt, method = "lms")
is_interaction_model(est_lms)
}

}
