% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mode-proper.R
\name{mode_first}
\alias{mode_first}
\title{The first-appearing mode}
\usage{
mode_first(x, na.rm = FALSE, accept = FALSE)
}
\arguments{
\item{x}{A vector to search for its first mode.}

\item{na.rm}{Boolean. Should missing values in \code{x} be removed before
computation proceeds? Default is \code{FALSE}.}

\item{accept}{Boolean. Should the first-appearing value known to be a mode be
accepted? If \code{FALSE} (the default), returns \code{NA} if a value that appears
earlier might be another mode due to missing values.}
}
\value{
The first mode (most frequent value) in \code{x}. If it can't be
determined because of missing values, returns \code{NA} instead.
}
\description{
\code{mode_first()} returns the mode that appears first in a vector, i.e., before
any other modes.
}
\examples{
# `2` is most frequent:
mode_first(c(1, 2, 2, 2, 3))

# Can't determine the first mode --
# it might be `1` or `2` depending
# on the true value behind `NA:
mode_first(c(1, 1, 2, 2, NA))

# Ignore `NA`s with `na.rm = TRUE`
# (there should be good reasons for this!):
mode_first(c(1, 1, 2, 2, NA), na.rm = TRUE)

# `1` is the most frequent value,
# no matter what `NA` stands for:
mode_first(c(1, 1, 1, 2, NA))

# By default, the function insists on
# the first mode, so it won't accept the
# first value *known* to be a mode if an
# earlier value might be a mode, too:
mode_first(c(1, 2, 2, NA))

# You may accept the first-known mode:
mode_first(c(1, 2, 2, NA), accept = TRUE)
}
\seealso{
\itemize{
\item \code{\link[=mode_all]{mode_all()}} for the full set of modes.
\item \code{\link[=mode_single]{mode_single()}} for the \emph{only} mode, or \code{NA} if there are more.
}
}
