% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditionaData.R
\name{conditionalDataMin}
\alias{conditionalDataMin}
\title{Segment data according to one or more random variables.}
\usage{
conditionalDataMin(
  df,
  features,
  selectedFeatureNames = c(),
  retainMinValues = 1
)
}
\arguments{
\item{df}{data.frame with data to segment. If it contains less than or
equally many rows as specified by \code{retainMinValues}, then the same
data.frame is returned.}

\item{features}{data.frame of bayes-features that are used to segment.
Each feature's value is used to segment the data, and the features are
used in the order as given by \code{selectedFeatureNames}. If those are
not given, then the order of this data.frame is used.}

\item{selectedFeatureNames}{default \code{c()}. Character vector with the
names of the variables that shall be used for segmenting. Segmenting is
done variable by variable, and the order depends on this vector. If this
vector is empty, then the originally given data.frame is returned.}

\item{retainMinValues}{default 1. The minimum amount of rows to retain.
Filtering the data by the selected features may reduce the amount of
remaining rows quickly, and this can be used as an early stopping criteria.
Note that filtering is done variable by variable, and the amount of
remaining rows is evaluated after each segmenting-step. If the threshold
is undercut, then the result from the previous round is returned.}
}
\value{
data.frame that is segmented according to the selected variables
and the minimum amount of rows to retain.
}
\description{
Takes a data.frame and segments it, according to the selected
variables. Only rows satisfying all conditions are kept. Supports discrete
and continuous variables. Supports NA, NaN and NULL by using is.na, is.nan
and is.null as comparator.
}
\examples{
feat1 <- mmb::createFeatureForBayes(
  name = "Petal.Length", value = mean(iris$Petal.Length))
feat2 <- mmb::createFeatureForBayes(
  name = "Petal.Width", value = mean(iris$Petal.Width))
feats <- rbind(feat1, feat2)

data <- mmb::conditionalDataMin(df = iris, features = feats,
  selectedFeatureNames = feats$name, retainMinValues = 1)
}
\seealso{
\code{getValueKeyOfBayesFeatures()}
}
\author{
Sebastian Hönel \href{mailto:sebastian.honel@lnu.se}{sebastian.honel@lnu.se}
}
\keyword{segmentation}
