% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{model_evaluation_examples}
\alias{model_evaluation_examples}
\title{Examples for model evaluation functions}
\description{
Examples for model evaluation functions
}
\examples{
\donttest{
library(randomForest)
library(caret)
data(panc_incidence)
mapdata <- join_data(africa_shp, panc_incidence, by = "NAME")
rf_model <- randomForest(incidence ~ female + male + agea + ageb + agec + fagea + fageb + fagec +
magea + mageb + magec + yrb + yrc + yrd + yre, data = mapdata, ntree = 500,
importance = TRUE)

rf_preds <- predict(rf_model, newdata = mapdata)
rf_metrics <- postResample(pred = rf_preds, obs = mapdata$incidence)
print(rf_metrics)
}
}
