% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionRegr.R
\name{autoplot.PredictionRegr}
\alias{autoplot.PredictionRegr}
\title{Plots for Regression Predictions}
\usage{
\method{autoplot}{PredictionRegr}(
  object,
  type = "xy",
  binwidth = NULL,
  theme = theme_minimal(),
  quantile = 1.96,
  ...
)
}
\arguments{
\item{object}{(\link[mlr3:PredictionRegr]{mlr3::PredictionRegr}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{binwidth}{(\code{integer(1)})\cr
Width of the bins for the histogram.}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{quantile}{(\code{numeric(1)})\cr
Quantile multiplier for standard errors for \code{type="confidence"}. Default 1.96.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for \link[mlr3:PredictionRegr]{mlr3::PredictionRegr}.
The argument \code{type} controls what kind of plot is drawn.
Possible choices are:
\itemize{
\item \code{"xy"} (default): Scatterplot of "true" response vs. "predicted" response.
By default a linear model is fitted via \code{geom_smooth(method = "lm")} to visualize the trend between x and y (by default colored blue).
In addition \code{geom_abline()} with \code{slope = 1} is added to the plot.
Note that \code{geom_smooth()} and \code{geom_abline()} may overlap, depending on the given data.
\item \code{"histogram"}: Histogram of residuals: \eqn{r = y - \hat{y}}{r = y - y.hat}.
\item \code{"residual"}: Plot of the residuals, with the response \eqn{\hat{y}}{y.hat} on the "x" and the residuals on the "y" axis.
By default a linear model is fitted via \code{geom_smooth(method = "lm")} to visualize the trend between x and y (by default colored blue).
\item \code{"confidence"}: Scatterplot of "true" response vs. "predicted" response with
confidence intervals. Error bars calculated as object$response +- quantile * object$se and so only
possible with \code{predict_type = "se"}. \code{geom_abline()} with \code{slope = 1} is added to the plot.
}
}
\examples{
if (mlr3misc::require_namespaces("mlr3learners", quietly = TRUE)) {
library(mlr3learners)

task = tsk("mtcars")
learner = lrn("regr.rpart")
object = learner$train(task)$predict(task)

head(fortify(object))
autoplot(object)
autoplot(object, type = "histogram", binwidth = 1)
autoplot(object, type = "residual")

learner = lrn("regr.ranger", predict_type = "se")
object = learner$train(task)$predict(task)
autoplot(object, type = "confidence")
}
}
