% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AcqOptimizerDirect.R
\name{AcqOptimizerDirect}
\alias{AcqOptimizerDirect}
\title{Direct Acquisition Function Optimizer}
\description{
Direct acquisition function optimizer.
Calls \code{nloptr()} from \CRANpkg{nloptr}.
In its default setting, the algorithm restarts \code{5 * D} times and runs at most for \code{100 * D^2} function evaluations, where \code{D} is the dimension of the search space.
Each run stops when the relative tolerance of the parameters is less than \code{10^-4}.
The first iteration starts with the best point in the archive and the next iterations start from a random point.
}
\note{
If the restart strategy is \code{"none"}, the optimizer starts with the best point in the archive.
The optimization stops when one of the stopping criteria is met.

If \code{restart_strategy} is \code{"random"}, the optimizer runs at least for \code{maxeval} iterations.
The first iteration starts with the best point in the archive and stops when one of the stopping criteria is met.
The next iterations start from a random point.
}
\section{Parameters}{

\describe{
\item{\code{restart_strategy}}{\code{character(1)}\cr
Restart strategy.
Can be \code{"none"} or \code{"random"}.
Default is \code{"none"}.
}
\item{\code{max_restarts}}{\code{integer(1)}\cr
Maximum number of restarts.
Default is \code{5 * D} (Default).}
}
}

\section{Termination Parameters}{

The following termination parameters can be used.

\describe{
\item{\code{stopval}}{\code{numeric(1)}\cr
Stop value.
Deactivate with \code{-Inf} (Default).}
\item{\code{maxeval}}{\code{integer(1)}\cr
Maximum number of evaluations.
Default is \code{100 * D^2}, where \code{D} is the dimension of the search space.
Deactivate with \code{-1L}.}
\item{\code{xtol_rel}}{\code{numeric(1)}\cr
Relative tolerance of the parameters.
Default is \code{10^-4}.
Deactivate with \code{-1}.}
\item{\code{xtol_abs}}{\code{numeric(1)}\cr
Absolute tolerance of the parameters.
Deactivate with \code{-1} (Default).}
\item{\code{ftol_rel}}{\code{numeric(1)}\cr
Relative tolerance of the objective function.
Deactivate with \code{-1}. (Default).}
\item{\code{ftol_abs}}{\code{numeric(1)}\cr
Absolute tolerance of the objective function.
Deactivate with \code{-1} (Default).}
}
}

\examples{
if (requireNamespace("nloptr")) {
  acqo("direct")
}
}
\section{Super class}{
\code{\link[mlr3mbo:AcqOptimizer]{mlr3mbo::AcqOptimizer}} -> \code{AcqOptimizerDirect}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{state}}{(\code{list()})\cr
List of \code{\link[nloptr:nloptr]{nloptr::nloptr()}} results.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{print_id}}{(\code{character})\cr
Id used when printing.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AcqOptimizerDirect-new}{\code{AcqOptimizerDirect$new()}}
\item \href{#method-AcqOptimizerDirect-optimize}{\code{AcqOptimizerDirect$optimize()}}
\item \href{#method-AcqOptimizerDirect-clone}{\code{AcqOptimizerDirect$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqOptimizer" data-id="format"><a href='../../mlr3mbo/html/AcqOptimizer.html#method-AcqOptimizer-format'><code>mlr3mbo::AcqOptimizer$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqOptimizer" data-id="print"><a href='../../mlr3mbo/html/AcqOptimizer.html#method-AcqOptimizer-print'><code>mlr3mbo::AcqOptimizer$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="AcqOptimizer" data-id="reset"><a href='../../mlr3mbo/html/AcqOptimizer.html#method-AcqOptimizer-reset'><code>mlr3mbo::AcqOptimizer$reset()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqOptimizerDirect-new"></a>}}
\if{latex}{\out{\hypertarget{method-AcqOptimizerDirect-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqOptimizerDirect$new(acq_function = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{acq_function}}{(\code{NULL} | \link{AcqFunction}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqOptimizerDirect-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-AcqOptimizerDirect-optimize}{}}}
\subsection{Method \code{optimize()}}{
Optimize the acquisition function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqOptimizerDirect$optimize()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with 1 row per candidate.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AcqOptimizerDirect-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AcqOptimizerDirect-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AcqOptimizerDirect$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
