% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitions_stra.R
\name{stratified.partitions}
\alias{stratified.partitions}
\title{Generic partitioning of an mldr object}
\usage{
stratified.partitions(mld, is.cv = FALSE, r, seed = 10,
  get.indices = FALSE)
}
\arguments{
\item{mld}{The \code{mldr} object to be partitioned}

\item{is.cv}{Option to enable treatment of partitions as cross-validation test folds}

\item{r}{A vector of percentages of instances to be selected for each partition}

\item{seed}{The seed to initialize the random number generator. By default is 10. Change it if you want to obtain partitions containing
different samples, for instance to use a 2x5 fcv strategy}

\item{get.indices}{A logical value indicating whether to return lists of indices or lists of \code{"mldr"} objects}
}
\value{
An \code{mldr.folds} object. This is a list containing k elements, one for each fold. Each element is made up
of two mldr objects, called \code{train} and \code{test}
}
\description{
Stratified partitioning

Generalization of the algorithm defined in:
  Charte, F., Rivera, A., del Jesus, M. J., & Herrera, F. (2016, April). On the
  impact of dataset complexity and sampling strategy in multilabel classifiers
  performance. In International Conference on Hybrid Artificial Intelligence
  Systems (pp. 500-511). Springer, Cham.
}
\examples{
\dontrun{
library(mldr.datasets)
library(mldr)
parts.emotions <- stratified.partitions(emotions, r = c(35, 25, 40))
summary(parts.emotions[[2]])
}
}
