% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-management.R
\name{gintervals.ls}
\alias{gintervals.ls}
\title{Returns a list of named intervals sets}
\usage{
gintervals.ls(
  pattern = "",
  db = NULL,
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  useBytes = FALSE
)
}
\arguments{
\item{pattern, ignore.case, perl, fixed, useBytes}{see 'grep'}

\item{db}{optional database path to filter intervals. If specified, only
interval sets from that database are returned.}
}
\value{
An array that contains the names of intervals sets.
}
\description{
Returns a list of named intervals sets in Genomic Database.
}
\details{
This function returns a list of named intervals sets that match the pattern
(see 'grep'). If called without any arguments all named intervals sets are
returned.

When multiple databases are connected, the 'db' parameter can be used to
filter intervals to only those from a specific database.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gintervals.ls()
gintervals.ls(pattern = "annot*")

}
\seealso{
\code{\link{grep}}, \code{\link{gintervals.exists}},
\code{\link{gintervals.load}}, \code{\link{gintervals.save}},
\code{\link{gintervals.rm}}, \code{\link{gintervals}},
\code{\link{gintervals.2d}}, \code{\link{gintervals.dataset}}
}
\keyword{~intervals}
\keyword{~ls}
