% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf-stream.R
\name{pdf_image}
\alias{pdf_image}
\title{Add image to a PDF doc}
\usage{
pdf_image(
  doc,
  im,
  x,
  y,
  scale = 1,
  interpolate = FALSE,
  ...,
  gp = pgpar(),
  tf = NULL,
  clip = NULL
)
}
\arguments{
\item{doc}{A \code{pdf_doc} object created by \code{\link{create_pdf}()}}

\item{im}{Image represented as a numeric matrix or array with all values 
       in range [0, 255].
\describe{
  \item{matrix}{A gray image}
  \item{array with 2 planes}{Gray image with an alpha channel}
  \item{array with 3 planes}{An RGB image}
  \item{array with 4 planes}{An RGB image with an alpha channel}
}}

\item{x, y}{position of bottom-left corner of image. (Length = 1)}

\item{scale}{scale factor when rendering image Default: 1. (Length = 1)}

\item{interpolate}{Should pixel values be interpolated? Default: FALSE. 
(Length = 1)}

\item{...}{further arguments to be added to \code{gp}}

\item{gp}{A named list \code{gp} object created by \code{\link{pgpar}()}}

\item{tf}{either a single transform (\code{tf_translate()}, \code{tf_scale()},
\code{tf_rotate()}), or a list of these transforms.  Default: NULL,
no local transformation applied (global transformations still apply)}

\item{clip}{either a single clip (\code{clip_rect()}, \code{clip_polygon()}),
or a list of these clips.  Default: NULL,
no local clipping applied (global clipping still applicable)}
}
\value{
\code{pdf_doc}
}
\description{
Add image to a PDF doc
}
\examples{
im <- matrix(1:100, 10, 10)
doc <- create_pdf() |>
   pdf_image(im, 20, 20, scale = 2)
}
\seealso{
Other object creation functions: 
\code{\link{pdf_bezier}()},
\code{\link{pdf_circle}()},
\code{\link{pdf_line}()},
\code{\link{pdf_polygon}()},
\code{\link{pdf_polyline}()},
\code{\link{pdf_rect}()},
\code{\link{pdf_text}()}
}
\concept{object creation functions}
