% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipping.R
\name{pdf_clip_rect}
\alias{pdf_clip_rect}
\title{Add a global clipping rectangle to a PDF doc}
\usage{
pdf_clip_rect(doc, x, y, width, height, tf = NULL)
}
\arguments{
\item{doc}{A \code{pdf_doc} object created by \code{\link{create_pdf}()}}

\item{x, y}{position}

\item{width, height}{size}

\item{tf}{either a single transform (\code{tf_translate()}, \code{tf_scale()},
\code{tf_rotate()}), or a list of these transforms.  Default: NULL,
no local transformation applied (global transformations still apply)}
}
\value{
\code{pdf_doc}
}
\description{
Clipping regions are cumulative, and these is no operation to expand the 
global clipping region.
use local clipping with the \code{clip} argument to individual objects.
}
\examples{
doc <- create_pdf() |>
   pdf_clip_rect(0, 0, 200, 200)
}
\seealso{
Other clipping functions: 
\code{\link{clip_polygon}()},
\code{\link{clip_rect}()},
\code{\link{pdf_clip_polygon}()}

Other global clipping functions: 
\code{\link{pdf_clip_polygon}()}
}
\concept{clipping functions}
\concept{global clipping functions}
