% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tnorm_rlcv}
\alias{tnorm_rlcv}
\title{Likelihood cross-validation for truncated normal kernel density estimation}
\usage{
tnorm_rlcv(x, Omega, beta, an, xsamp, dxsamp, mckern = TRUE)
}
\arguments{
\item{x}{\code{n} by \code{d} matrix of observations}

\item{Omega}{smoothing positive-definite matrix}

\item{beta}{vector of constraints for the half-space}

\item{an}{threshold for linear approximation}

\item{xsamp}{\code{n} by \code{d} random sample for Monte Carlo estimation of bias}

\item{dxsamp}{\code{n} vector of density for the points from \code{xsamp}}

\item{mckern}{logical; if \code{TRUE}, uses the kernel as sampler for Monte Carlo estimation}
}
\value{
RLCV criterion value
}
\description{
Robust likelihood cross-validation criterion function.
}
\keyword{internal}
