% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gauss_rlcv}
\alias{gauss_rlcv}
\title{Robust likelihood cross-validation for Gaussian kernel density estimation}
\usage{
gauss_rlcv(x, Sigma, logweights, an, xsamp, dxsamp, mckern = TRUE)
}
\arguments{
\item{x}{\code{n} by \code{d} matrix of observations}

\item{Sigma}{smoothing positive-definite matrix}

\item{logweights}{log vector of weights}

\item{an}{threshold for linear approximation}

\item{xsamp}{\code{n} by \code{d} random sample for Monte Carlo estimation of bias}

\item{dxsamp}{\code{n} vector of density for the points from \code{xsamp}}

\item{mckern}{logical; if \code{TRUE}, uses the kernel as sampler for Monte Carlo estimation}
}
\value{
RLCV criterion value
}
\description{
Robust likelihood cross-validation criterion function of Wu.
}
\keyword{internal}
