% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_encoder.R
\name{factor.encoder}
\alias{factor.encoder}
\alias{factor.frame}
\title{Encoder for Qualitative Variables}
\usage{
factor.encoder(
  x,
  k,
  use.catchall = TRUE,
  catchall = "(others)",
  tag = "x",
  frame = NULL,
  weights = NULL
)

factor.frame(levels, catchall = "(others)", tag = "x")
}
\arguments{
\item{x}{a vector to be encoded as a qualitative variable.}

\item{k}{an integer specifying the maximum number of distinct levels to retain (including the catch-all level). If not positive, all unique values of \code{x} are used.}

\item{use.catchall}{logical. If \code{TRUE}, less frequent levels are grouped into the catch-all level.}

\item{catchall}{a character string for the catch-all level.}

\item{tag}{the name of the variable.}

\item{frame}{a "factor.frame" object or a character vector that explicitly defines the levels of the variable.}

\item{weights}{an optional numeric vector of sample weights for \code{x}.}

\item{levels}{a vector to be used as the levels of the variable.}
}
\value{
\code{factor.encoder()} returns an object of class "encoder". This is a list containing the following components:
\item{frame}{a "factor.frame" object containing the encoding information (levels).}
\item{encode}{a function to convert a vector \code{x} into a one-hot encoded matrix.}
\item{n}{the number of encoding levels (i.e., columns in the design matrix).}
\item{type}{a character string describing the encoding type: "factor" or "null".}

\code{factor.frame()} returns a "factor.frame" object containing the encoding information.
}
\description{
\code{factor.encoder()} creates an encoder function for a qualitative (factor or character) variable.
This encoder converts the variable into a one-hot encoded (dummy) design matrix.

\code{factor.frame()} is a helper function to create a "factor.frame" object that defines the encoding scheme.
}
\details{
This function is designed to handle qualitative data for use in the MID model's linear system formulation.

The primary mechanism is one-hot encoding.
Each unique level of the input variable becomes a column in the output matrix.
For a given observation, the column corresponding to its level is assigned a \code{1}, and all other columns are assigned \code{0}.

When a variable has many unique levels (high cardinality), you can use the \code{use.catchall = TRUE} and \code{k} arguments.
This will group the \code{k - 1} most frequent levels into their own columns, while all other less frequent levels are consolidated into a single \code{catchall} level (e.g., "(others)" by default).
This is crucial for preventing MID models from becoming overly complex.
}
\examples{
# Create an encoder for a qualitative variable
data(iris, package = "datasets")
enc <- factor.encoder(x = iris$Species, use.catchall = FALSE, tag = "Species")
enc

# Encode a vector with NA
enc$encode(x = c("setosa", "virginica", "ensata", NA, "versicolor"))

# Create an encoder with a pre-defined encoding frame
frm <- factor.frame(c("setosa", "virginica"), "other iris")
enc <- factor.encoder(x = iris$Species, frame = frm)
enc
enc$encode(c("setosa", "virginica", "ensata", NA, "versicolor"))

# Create an encoder with a character vector specifying the levels
enc <- factor.encoder(x = iris$Species, frame = c("setosa", "versicolor"))
enc$encode(c("setosa", "virginica", "ensata", NA, "versicolor"))
}
\seealso{
\code{\link{numeric.encoder}}
}
