% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_sign_test.R
\name{apply_sign_test}
\alias{apply_sign_test}
\title{Apply sign test}
\usage{
apply_sign_test(
  stats_data,
  summarized_data,
  value = "Value",
  p.signif = "p.signif",
  grouping = NULL,
  na = "NA"
)
}
\arguments{
\item{stats_data}{A data frame containing the calculated growth performance data,
e.g. via a function call to \code{calculate_growth_performance}.}

\item{summarized_data}{A data frame containing corresponding summarized data, e.g. via function call
\code{summarize_growth_performance}.}

\item{value}{The column containing absorption values to be tested. Defaults to 'Value'.}

\item{p.signif}{The column containing significance denoted in asterisk notation. Defaults
to 'p.signif'.}

\item{grouping}{A character vector specifying the grouping variables.}

\item{na}{A character value specifying the keyword to display if sign tests cannot be applied
on subsets of the data (e.g. because of too small sample sizes). Defaults to "NA".}
}
\value{
A data frame containing the summarized data with sign test results added.
}
\description{
This function applies the one-sample sign test to input data grouped by specified variables.
}
\seealso{
\code{\link{calculate_growth_performance}}, \code{\link{summarize_growth_performance}},
\code{\link{plot_growth_performance}},
}
