% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microbiomeMQC.R
\name{microbiomeMQC}
\alias{microbiomeMQC}
\title{Calculate 4 key reporting measures}
\usage{
microbiomeMQC(input, taxonomic_level, output)
}
\arguments{
\item{input}{Path to the .xlsx or .csv file.e.g. "C:\\Users\\joeblogs\\Desktop\\data.xlsx"}

\item{taxonomic_level}{The taxonomic level ("strain", "species", or "genus") that you are using.}

\item{output}{Path to save the output CSV file (file path must end with the file name e.g. "C:\\Users\\joeblogs\\Desktop\\MQC.csv"}
}
\value{
No return value. The function writes the results to the specified CSV file.
}
\description{
Calculate the 4 key reporting measures for the WHO International Reference Reagents for the microbiome
}
\details{
The 4 key reporting measures (using the example of species) are:

Sensitivity: How many species from the reagent are correctly identified.

Diversity: The total number of species detected.

FPRA: The relative abundance of false positives.

Similarity: The Bray-Curtis dissimilarity in composition between the species profile reported and the 'ground truth' profile of the reagent.

To see how the data should be formatted do: data(MQC_testdata)
FP = false positive i.e. those bacteria that do not appear in the reagent
}
\examples{
input <- system.file("extdata", "MQC_testdata.csv", package = "microbiomeMQC")
output <- tempfile(fileext = ".csv")
microbiomeMQC(input, "species", output)
}
